// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonne.h"
#include <cc++/slog.h>
#include <cc++/process.h>
#include <ccrtp/rtp.h>
#undef	HAVE_CONFIG_H
#ifdef	HAVE_EXOSIP2
#include <osip2/osip_mt.h> 
#include <eXosip2/eXosip.h>
#else
#include <eXosip/eXosip.h>
#endif

namespace sipdriver {
using namespace ost;
using namespace std;

class Session;

class Registry : public ScriptRegistry
{
public:
	const char *uri, *contact, *proxy;
	const char *iface;
//	const char *route;
	const char *hostid;
	const char *portid;
	const char *userid;
	const char *secret;
	const char *type;
	const char *realm;
	const char *dtmf;
	int regid;
	bool active;
};
	
class Driver : public BayonneDriver, public Audio, public Thread
{
protected:
	friend class Session;
	friend class RTPStream;

	InetAddress sip_addr, rtp_addr;
	tpport_t rtp_port, sip_port;
	uint8 dtmf_payload, data_payload;
	Info info;
	bool registry;
	bool exiting;
	bool dtmf_inband;
	bool data_filler;
	Level silence;
	Linear silent_frame;
	Encoded silent_encoded;
	unsigned jitter;
	timeout_t accept_timer;
	timeout_t audio_timer;

public:
	static Driver sip;		// plugin activation

	Driver();

	inline tpport_t getPort(void)
		{return sip_port;};

	void startDriver(void);
	void stopDriver(void);
	const char *registerScript(ScriptImage *img, Line *line);
	const char *assignScript(ScriptImage *img, Line *line);

	Session *getCall(int callid);

	bool getDestination(const char *target, const char *dial, char *buffer, size_t size);

	void run(void);
	void refresh(void);
	bool authenticate(Session *s);

	inline Level getSilence(void)
		{return silence;};
};

class RTPStream : public SymmetricRTPSession, public AudioBase, private TimerPort, private Mutex, public Bayonne
{
private:
	friend class Session;

protected:
	DTMFDetect *dtmf;
        Session *session;
        size_t rtpBufferSize;
        bool dropInbound;
	bool ending;
	unsigned long fcount, jitter, jsend;
	
	unsigned lastevt;
	unsigned tonecount;
	event_t stopid;

        AudioBase *source, *sink;
	AudioTone *tone;

public:
        uint32  iBytes;
        uint32  oBytes;
        uint32  oTimestamp;

	RTPStream(Session *session);
	~RTPStream();

        void start(void);

        ssize_t putBuffer(Encoded data, size_t len);
        ssize_t getBuffer(Encoded data, size_t len);

        void run(void);
	void peerAudio(Encoded encoded);

        void setSource(AudioBase *get, timeout_t max = 0);
        void setSink(AudioBase *put, timeout_t max = 0);
	void setTone(AudioTone *tone, timeout_t max = 0);

	inline bool isEnding(void)
		{return ending;};

    	bool onRTPPacketRecv(IncomingRTPPkt &pkt);
};

// in this driver we really only have one instance of session since we
// only use one timeslot, but the coding style is more reflective of
// drivers with multiport
class Session : public BayonneSession, public TimerPort, public Audio
{
protected:
	friend class Driver;
	friend class RTPStream;

	AudioCodec *codec;
	InetHostAddress local_address, remote_address;
	tpport_t remote_port;
	RTPStream *rtp;
	bool update_pos;
	Encoded buffer;
	Linear lbuffer;
	Linear peer_buffer;
	AudioCodec *peer_codec;
	uint8 dtmf_payload, data_payload;
	volatile bool dtmf_inband;

	int cid, did;

	bool peerAudio(Encoded encoded);
	void postAudio(Encoded encoded);

	void sendDTMFInfo(char digit, unsigned timeout = 160);

	void setDTMFMode(const char *mode);

public:
	Session(timeslot_t ts);
	~Session();

	const char *checkAudio(bool live);

	// core timer virtuals all port session objects need to define
	timeout_t getRemaining(void);
	void startTimer(timeout_t timer);
	void stopTimer(void);

	void startRTP(void);
	
	void stopRTP(void);

	void makeIdle(void);

	void clrAudio(void);

	bool enterSeize(Event *event);

	bool enterRunning(Event *event);

	bool enterHangup(Event *event);

	bool enterPickup(Event *event);

	bool enterPlay(Event *event);

	bool enterRecord(Event *event);

	bool enterTone(Event *event);

	bool enterXfer(Event *event);

	timeout_t getToneFraming(void);

	tpport_t getLocalPort(void);

	void sipAnswer(int code);

	void sipHangup(void);

	inline tpport_t getRemotePort(void)
		{return remote_port;};

	inline InetHostAddress getLocalAddress(void)
		{return local_address;};

	inline InetHostAddress getRemoteAddress(void)
		{return remote_address;};
};

}

