/* LocaleInformation_fr.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_fr extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "dinar jordanien|Bolivian Mvdol|Or|Faeroe Islands Kronur|livre libanaise|euro|dong|shilling de Tanzanie|peso bolivien|riel|unit\u00e9 mon\u00e9taire asiatique|boliviano (1863-1962)|vieux riel|livre zambienne|livre australienne|franc CFA (BEAC)|livre maltaise|cedi revaloris\u00e9|kwacha|dinar asiatique (unit\u00e9 de compte)|livre ghan\u00e9enne|boliviano|ancien cedi|lire maltaise|dollar australien|dollar des Etats-Unis (jour m\u00eame)|lire italienne|dollar des Etats-Unis (jour suivant)|c\u00e9di|dollar de Singapour|balboa|kip|som du Kyrgystan|franc suisse|schilling autrichien|dollar des \u00c9tats-Unis|dollar \u00e9thiopien|dollar de Brunei|livre jama\u00efcaine|birr|franc germinal alg\u00e9rien|nouveau franc alg\u00e9rien|dinar alg\u00e9rien|guarani|livre libyenne|dollar jama\u00efcain|couronne islandaise|peseta espagnole|livre des Bermudes|dinar Iibyen|lire de l\u2019autori\u00e9 militaire britannique de Libye|dollar des Bermudes|florin n\u00e9erlandais|ouguija|rial iranien|couronne su\u00e9doise|Eritrean Nakfa|shilling du Kenya|franc CFA de la R\u00e9publique du Centre Afrique|peso argentin|peso argentin (1983-1985)|Argentine Peso Moneda Nacional|dollar ta\u00efwanais|livre soudanaise|lari|Georgian Kupon Larit|franc martiniquais|livre des Falkland (Malvinas)|austral|dinar soudanais|dinar irakien|dollar du Tuvalu|roupie des Seychelles|rouble letton|livre de Fiji|lats letton|Congolese Zaire|franc de la R\u00e9publique Congolaise|franc congolais|dollar de Fidji|cordoba d\u2019or|pataca|cordoba d\u2019or|cordoba|rouble transf\u00e9rable du COMECON|mark finlandais (1860-1962)|mark finlandais|dollar de Salomon|franc luxembourgeois|vieux dollar de la Trinit\u00e9|escudo angolais|kwanza angolais r\u00e9ajust\u00e9 (1995-1999)|tugrik|forint|franc du Burundi|nouveau kwanza angolais (1990-2000)|kwanza angolais (1977-1990)|dollar de la Trinit\u00e9|lilangeni|franc CFP des Nouvelles H\u00e9brides|livre sterling|riyal saoudien|riyal s\u00e9oudien|Talonas de Lithuanie|roupie indienne|escudo portugais|kwanza angolais|conto portugais|Lita de Lithuanian|tenge du Kazakhstan|rouble du Kazakhstan|dollar des \u00eeles Vierges britanniques|livre nig\u00e9riane|dollar de Myanmar (certificat de devises \u00e9trang\u00e8res)|naira|gourde|livre syrienne|livre palestinienne|dinar de Bahrein|Myanmar Kyat|florin des Antilles n\u00e9erl.|couronne tch\u00e8que|livre sterling de l\u2019Ile de Man|lev (certificat de devises \u00e9trang\u00e8res)|Lesotho Loti|franc CFA gabonnais|lev (1879-1952)|nouveau lef|lev de Bulgarie socialiste|dollar canadien|lev|livre turque|dollar des \u00eeles Ca\u00efmans|livre cypriote|sh\u00e9kel|dollar de Guyane|dram arm\u00e9nien|livre isra\u00e9lienne|franc malien|sh\u00e9kel|bolivar|dollar albanais (certificat de devises \u00e9trang\u00e8res)|dollar lib\u00e9rien|Albanian Lek Valute|kuna|franc de la R\u00e9union|dinar croate|lek albanais|livre sterling de Jersey|lek albanais (1946-1961)|dinar mac\u00e9donien (1992-1993)|North Vietnam Viet Minh Piastre Dong Viet|nouveau dong nord-vietnamien|dinar mac\u00e9donien|North Vietnam Piastre Dong Viet|pataca de Timor|franc CFP|franc belge (financier)|peso de Guin\u00e9e-Bissau|dinar koweitien|Portuguese Guinea Mil Reis|franc belge|escudo de Timor|franc belge (convertible)|Escudo de Guin\u00e9e Portugaise|colon|florin de Curacao|taka|livre sterling du Tonga|pa\u02bbanga|franc CFA (BCEAO)|rouble de C.E.I.|nouveau rouble sovi\u00e9tique|franc Germinal de Nouvelle Cal\u00e9donie|escudo du Cap-Vert|franc CFA antillais|rand|peso dominicain|certificat de devises \u00e9trang\u00e8res de Cuba|livre sud-africaine|rand sud-africain (financier)|dinar tunisien|peso cubain|franc guyanais|shilling ougandais|roupie de Ceylan|franc Affars et Issas|lire du Vatican|escudo de Sao Tom\u00e9 et Principe|shilling ougandais (1966-1987)|dobra|dollar des  \u00eeles Marshall|livre n\u00e9o-z\u00e9landaise|tala|livre du Samoa|lempira|nouveau franc m\u00e9tropolitain|Turkmenistan Manat|quetzal|dollar n\u00e9o-z\u00e9landais|livre \u00e9cossaise|dollar de Barbade|dollar de Namibie|franc malgache|ariary malgache|livre \u00e9gyptienne|dollar du Honduras britannique|zloty (1950-1995)|nouveau dinar de Bosnie-Herzegovine|dollar US polonais (certificat de devises \u00e9trang\u00e8res)|mark convertible de Bosnie-Herzegovine|dollar de B\u00e9lize|dinar de Bosnie-Herzegovine|riyal du Y\u00e9men|florin du Surinam|couronne tch\u00e8que|won sud-cor\u00e9en|rouble bi\u00e9lorusse|riyal du Y\u00e9men|rouble bi\u00e9lorusse (1992-1994)|couronne tch\u00e8que|vieux won|hwan|nouveau rouble bi\u00e9lorusse (1994-1999)|shilling de Somalie|nouveau drachme|roupie du Pakistan|afghani|dollar du Zimbabwe|roupie de Sri Lanka|drachme|livre irlandaise|afghani|dinar du Y\u00e9men|franc du Rwanda|colon|somoni du Tadjikistan|rouble du Tadjikistan|couronne estonienne|peseta de Guin\u00e9e Equatoriale|rouble moldave|dollar de Hong Kong|couronne danoise|leu moldave|franco de Guin\u00e9e Equatoriale|ekw\u00e9l\u00e9|rupiah|dirham des \u00c9mirats arabes unis|won nord-cor\u00e9en|nouvelle roupie indon\u00e9sienne|pula|Moldovan Leu Cupon|roupie de Java|won du peuple nord-cor\u00e9en|florin de Nica|vatu|dinar musulman|shilling de Somalie|peseta andorrane|rouble de Russie (1991-1998)|franc guadeloup\u00e9en|franc de Djibouti|diner andorran|franc Germinal mon\u00e9gasque|nouveau franc marocain|unit\u00e9 de valeur constante \u00e9quatoriale (UVC)|sucre|franc du Liechtenstein|peso philippin|sum|peso colombien|baht|livre d\u2019Irlande du Nord|roupie de Birmanie|franc CFA congolais|kyat|Colombian Paper Peso|Uzbekistan Coupon Som|karbovanetz|rial du Qatar|hryvnia|syli|Yuan Ren-min-bi|m\u00e9tical|dollar US chinois (certificat de devises \u00e9trang\u00e8res)|peso uruguayen|franc guin\u00e9en (1960-1972)|lire de Saint-Marin|Chinese Jen Min Piao Yuan|escudo du Mozambique|franc guin\u00e9en|Oman Rial Saidi|kina|rial omani|peso uruguayen (1975-1993)|franc UIC|roupie de Bhoutan|za\u00efre|franc marocain|dirham marocain|ngultrum|franc or|peso fort uruguayen|ringgit|nouveau za\u00efre|Azerbaijanian Manat|livre de Gambie|franc des Comores|l\u00e9one|dalasie|unit\u00e9 de compte europ\u00e9enne (ECU)|livre des Bahamas|franc CFA camerounais|unit\u00e9 de conversion mexicaine (UDI)|franc CFA (BCEAEC)|dollar des Bahamas|peso d\u2019argent mexicain (1861-1992)|sol p\u00e9ruvien|couronne du Groenland|cruzeiro (1942-1967)|nouveau sol p\u00e9ruvien|peso chilien|couronne slovaque|Inti p\u00e9ruvien|cruzeiro|franc germinal/franc Poincar\u00e9|franc fran\u00e7ais|nouveau cruzado|Chilean Unidades de Fomento|escudo chilien|r\u00e9al|condor chilien|cruzeiro (1990-1993)|sperrmark allemand|livre de Malawi|cruzeiro|nouveau cruzeiro (1967-1986)|kwacha|rouble moldave|deutsche mark|franc CFA du Tchad|nouveau rouble moldave|Transdniestria Ruble Kupon|roupie du N\u00e9pal|dollar des \u00eeles Cook|yen|roupie des Maldives|nouveau franc CFA|roupie des Maldives|dollar des Cara\u00efbes|tolar slov\u00e8ne|dinar yougoslave r\u00e9form\u00e9|florin d\u2019Aruba|dinar yougoslave d\u2019Octobre|mark est-allemand|dinar yougoslave convertible|dinar yougoslave Noviy|couronne des \u00eeles Turks et Ca\u00efques|dinar yougoslave 1994|dinar de la F\u00e9d\u00e9ration Yougoslave|nouveau leu|nouveau dinar yougoslave|leu|bons de tolar slov\u00e8ne|couronne norv\u00e9gienne|roupie de l\u2019\u00eele Maurice|unit\u00e9 de compte europ\u00e9enne (XBD)|livre de Gibraltar|dong national du Vietnam|unit\u00e9 de compte europ\u00e9enne (XBC)|dong de la R\u00e9publique Vietnamienne|unit\u00e9 mon\u00e9taire europ\u00e9enne|unit\u00e9 composite europ\u00e9enne|dollar de Kiribati|livre de Sainte-H\u00e9l\u00e8ne|nouveau dong vietnamien";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|PGK|OMS|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|AUD|USS|USN|GHC|SGD|PAB|LAK|som|sFr.|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|Arg$|ARP|ARM|TWD|SDP|lari|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|CAD|BGL|TL|KYD|CYP|ILS|G$|dram|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|XPF|BEL|GWP|KWD|GWM|FB|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZD|BAD|YER|SRG|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|Af|Z$|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|Ur$|GNI|SML|MZE|CNP|GF|PGK|OMS|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRG|F|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "janv.",
    "f\u00e9vr.",
    "mars",
    "avr.",
    "mai",
    "juin",
    "juil.",
    "ao\u00fbt",
    "sept.",
    "oct.",
    "nov.",
    "d\u00e9c.",
    null,
  };

  private static final String[] months = {
    "janvier",
    "f\u00e9vrier",
    "mars",
    "avril",
    "mai",
    "juin",
    "juillet",
    "ao\u00fbt",
    "septembre",
    "octobre",
    "novembre",
    "d\u00e9cembre",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dim.",
    "lun.",
    "mar.",
    "mer.",
    "jeu.",
    "ven.",
    "sam.",
  };

  private static final String[] weekdays = {
    null,
    "dimanche",
    "lundi",
    "mardi",
    "mercredi",
    "jeudi",
    "vendredi",
    "samedi",
  };

  private static final String[] eras = {
    "av. J.-C.",
    "ap. J.-C.",
  };

  private static final String[][] zoneStrings =
  {
    { "HNP (\u00c9UA)", "Heure normale du Pacifique (\u00c9UA)", "HAP (\u00c9UA)", "Heure avanc\u00e9e du Pacifique (\u00c9UA)",  "America/Los_Angeles" },
    { "HST", "Heure normale d\u2019Hawa\u00ef", "HDT", "Heure avanc\u00e9e d\u2019Hawa\u00ef",  "Pacific/Honolulu" },
    { "GMT", "Temps Moyen de Greenwich", "GMT", "Temps Moyen de Greenwich",  "Etc/GMT" },
    { "HNR (\u00c9UA)", "Heure normale des Rocheuses (\u00c9UA)", "HAR (\u00c9UA)", "Heure avanc\u00e9e des Rocheuses (\u00c9UA)",  "America/Phoenix" },
    { "HNR (\u00c9UA)", "Heure normale des Rocheuses (\u00c9UA)", "HAR (\u00c9UA)", "Heure avanc\u00e9e des Rocheuses (\u00c9UA)",  "America/Denver" },
    { "HNI", "Heure normale d\u2019Isra\u00ebl", "HAI", "Heure avanc\u00e9e d\u2019Isra\u00ebl",  "Asia/Jerusalem" },
    { "HNR", "Heure normale des Rocheuses", "HAR", "Heure avanc\u00e9e des Rocheuses",  "America/Edmonton" },
    { "HNAK", "Heure normale de l\u2019Alaska", "HAAK", "Heure avanc\u00e9e de l\u2019Alaska",  "America/Anchorage" },
    { "HNEC", "Heure normale de l\u2019Europe centrale", "HAEC", "Heure avanc\u00e9e de l\u2019Europe centrale",  "Europe/Paris" },
    { "HNE (\u00c9UA)", "Heure normale de l\u2019Est (\u00c9UA)", "HAE (\u00c9UA)", "Heure avanc\u00e9e de l\u2019Est (\u00c9UA)",  "America/Indianapolis" },
    { "HEE", "Heure normale de l\u2019Europe de l\u2019Est", "HAEE", "Heure avanc\u00e9e de l\u2019Europe de l\u2019Est",  "Europe/Bucharest" },
    { "HNJ", "Heure normale du Japon", "HAJ", "Heure avanc\u00e9e du Japon",  "Asia/Tokyo" },
    { "HNC", "Heure normale du Centre", "HAC", "Heure avanc\u00e9e du Centre",  "America/Winnipeg" },
    { "HNC", "Heure normale de Chine", "HAC", "Heure avanc\u00e9e de Chine",  "Asia/Shanghai" },
    { "HNP", "Heure normale du Pacifique", "HAP", "Heure avanc\u00e9e du Pacifique",  "America/Vancouver" },
    { "HNE (\u00c9UA)", "Heure normale de l\u2019Est (\u00c9UA)", "HAE (\u00c9UA)", "Heure avanc\u00e9e de l\u2019Est (\u00c9UA)",  "America/New_York" },
    { "HNE", "Heure normale de l\u2019Est", "HAE", "Heure avanc\u00e9e de l\u2019Est",  "America/Montreal" },
    { "HNA", "Heure normale de l\u2019Atlantique", "HAA", "Heure avanc\u00e9e de l\u2019Atlantique",  "America/Halifax" },
    { "HNT", "Heure normale de Terre-Neuve", "HAT", "Heure avanc\u00e9e de Terre-Neuve",  "America/St_Johns" },
    { "HNC (\u00c9UA)", "Heure normale du Centre (\u00c9UA)", "HAC (\u00c9UA)", "Heure avanc\u00e9e du Centre (\u00c9UA)",  "America/Chicago" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor-Leste|Tokelau|Tadjikistan|Tha\u00eflande|Togo|Terres australes fran\u00e7aises|Guyana|Tchad|\u00celes Turks et Ca\u00efques|Guin\u00e9e-Bissau|Guam|Guatemala|G\u00e9orgie du Sud, \u00celes Sandwich du Sud|Gr\u00e8ce|Guin\u00e9e \u00e9quatoriale|Guadeloupe|Swaziland|Syrie|Guin\u00e9e|Gambie|Groenland|El Salvador|Sao Tom\u00e9-et-Principe|Gibraltar|Ghana|Suriname|Guyane fran\u00e7aise|Serbie|G\u00e9orgie|Somalie|Grenade|S\u00e9n\u00e9gal|Saint-Marin|Royaume-Uni|Sierra Leone|Gabon|Slovaquie|Svalbard et \u00cele Jan Mayen|Slov\u00e9nie|Sainte-H\u00e9l\u00e8ne|Singapour|Su\u00e8de|Soudan|Seychelles|\u00celes Salomon|Arabie saoudite|France|\u00celes F\u00e9ro\u00e9|Micron\u00e9sie|Rwanda|\u00celes Falkland (Malvinas)|Russie|Fidji|Finlande|Roumanie|R\u00e9union|\u00c9thiopie|Espagne|\u00c9rythr\u00e9e|Sahara occidental|\u00c9gypte|Estonie|\u00c9quateur|Alg\u00e9rie|Qatar|R\u00e9publique dominicaine|Paraguay|Dominique|Palaos|Danemark|Djibouti|Portugal|Territoire palestinien|Porto Rico|Allemagne|Pitcairn|Saint-Pierre-et-Miquelon|Pologne|Pakistan|Philippines|Papouasie-Nouvelle-Guin\u00e9e|Polyn\u00e9sie fran\u00e7aise|R\u00e9publique tch\u00e8que|P\u00e9rou|Chypre|\u00cele Christmas|Cap Vert|Panama|Cuba|Costa Rica|Colombie|Chine|Cameroun|Chili|\u00celes Cook|C\u00f4te d\u2019Ivoire|Suisse|Congo|R\u00e9publique centrafricaine|R\u00e9publique d\u00e9mocratique du Congo|\u00celes Cocos|Oman|Canada|Belize|B\u00e9larus|Botswana|\u00cele Bouvet|Bhoutan|Bahamas|Br\u00e9sil|Nouvelle-Z\u00e9lande|Bolivie|Brunei|Bermudes|Niu\u00e9|Benin|Burundi|Bahre\u00efn|Nauru|Bulgarie|Burkina Faso|N\u00e9pal|Belgique|Norv\u00e8ge|Bangladesh|Barbade|Zimbabwe|Pays-Bas|Bosnie-Herz\u00e9govine|Nicaragua|Nig\u00e9ria|\u00cele Norfolk|Azerba\u00efdjan|Niger|Nouvelle-Cal\u00e9donie|Aruba|Zambie|Namibie|Australie|Autriche|Samoa am\u00e9ricaines|Argentine|Antarctique|Mozambique|Angola|Malaisie|Antilles n\u00e9erlandaises|Mexique|Arm\u00e9nie|Malawi|Albanie|Maldives|Afrique du Sud|Maurice|Malte|Anguilla|Montserrat|Mauritanie|Antigua-et-Barbuda|Martinique|Afghanistan|\u00celes Mariannes du Nord|\u00c9mirats arabes unis|Macao R.A.S. de Chine|Andorre|Mongolie|Myanmar|Mali|Mac\u00e9doine|Yougoslavie|Mayotte|\u00celes Marshall|Madagascar|Moldova|Monaco|Maroc|Y\u00e9men|Libye|Lettonie|Luxembourg|Lithuanie|Lesotho|Lib\u00e9ria|Sri Lanka|Liechtenstein|Sainte-Lucie|Liban|Laos|Kazakhstan|\u00celes Ca\u00efmanes|Kowe\u00eft|Cor\u00e9e du Sud|Cor\u00e9e du Nord|Saint Kitts et Nevis|Comores|Kiribati|Samoa|Cambodge|Kirghizistan|Kenya|Wallis et Futuna|Japon|Jordanie|Jama\u00efque|Vanuatu|Viet Nam|\u00celes Vierges des \u00c9tats-Unis|\u00celes Vierges Britanniques|V\u00e9n\u00e9zuela|Saint-Vincent-et-les Grenadines|Saint-Si\u00e8ge (Etat de la Cit\u00e9 du Vatican)|Italie|Islande|Iran|Iraq|Ouzb\u00e9kistan|Territoire britannique de l\u2019oc\u00e9an indien|Uruguay|Inde|Isra\u00ebl|\u00c9tats-Unis|Irlande|Indon\u00e9sie|\u00celes Mineures \u00c9loign\u00e9es des \u00c9tats-Unis|Ouganda|Ukraine|Hongrie|Ha\u00efti|Croatie|Tanzanie|Honduras|\u00celes Heard et MacDonald|Ta\u00efwan|Tuvalu|Hong-Kong R.A.S. de Chine|Trinit\u00e9-et-Tobago|Turquie|Tonga|Tunisie|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|root|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwich\u02bbin|akkadien|ekajuk|ijo|xhosa|sum\u00e9rien|soussou|langues diverses|lozi|tonga (Nyasa)|pohnpei|minangkabau|sukuma|wolof|mongo|kutenai|micmac|wallon|koumyk|zapot\u00e8que|couchitiques (autre)|lojban|dogra|volap\u00fck|langues otomangues|vietnamien|va\u00ef|rarotongan|venda|rapanui|rajasthani|turc ottoman (1500-1928)|nzema|napolitain|ouzbek|ougaritique|tamacheq|indiennes d\u2019Am\u00e9rique du Nord (autre)|nahuatl|ourdou|fanti|ukrainien|\u00e9gyptien (ancien)|ou\u00efgour|fang|nilo-sahariennes (autre)|irlandais moyen (900-1200)|baltique (autre)|nyoro|bassa|nyankol\u00e9|nyamwezi|hmong|Balinais|osage|baloutchi|tahitien|langues bamilekes|twi|s\u00e9r\u00e8re|tlingit|tatar|tsonga|banda|turc|tongan (\u00celes Tonga)|setswana|tagalog|turkm\u00e8ne|tigrigna|tha\u00ef|kurukh|tadjik|blin|t\u00e9lougou|kru|cashubian|tamoul|tokelau|efik|swahili|su\u00e9dois|soundanais|karacay-balkar|sotho du Sud|swati|serbe|albanais|mend\u00e9|pidgins et langues cr\u00e9oles (autre)|somali|afrihili|shona|samoan|slov\u00e8ne|vieux grec (avant 1453)|slovaque|grebo|singhalais|serbo-croate|turc de Crim\u00e9e; tatar de Crim\u00e9e|afro-asiatique (autre)|sango|sami du Nord|sindhi|oudmourte|sarde|sanskrit|rwanda|russe|mandar|roumain|roundi|rh\u00e9to-roman|moksa|tiv|adygu\u00e9|zuni|kpell\u00e9|quechua|tigr\u00e9|songhai|pidgin portugais (autre)|sogdien|adangme|kusaien|hittite|pidgin fran\u00e7ais (autre)|pidgin anglais (autre)|himachali|konkani|hiligaynon|gotique|gorontalo|gondi|dinka|langues nubiennes|portugais|pachto|frioulan|ph\u00e9nicien|allemand, vieux haut (ca. 750-1050)|sonink\u00e9|copte|yapois|acoli|yao|philippines (autre)|polonais|aceh|pali|pendjabi|bugi|iban|sami skolt|buriat|masai|sami d\u2019Inari|oss\u00e8te|malayo-polyn\u00e9sien|oriya|meninka|sami de Lule|sami (autre)|makasar|galla|maithili|ojibwa|magahi|madurais|sami du Sud|occitan (apr\u00e8s 1500)|sotho du Sud	|batak|erzya|dogrib|nyanja|langue maya|navaho|kiMboundou|nd\u00e9b\u00e9l\u00e9 du Sud|allemand, moyen haut (ca. 1050-1500)|norv\u00e9gien|nynorsk norv\u00e9gien|n\u00e9erlandais|racine|ndonga|slaves (autre)|n\u00e9palais|nd\u00e9b\u00e9l\u00e9 du Nord|chames, langues|tetum|bokm\u00e5l norv\u00e9gien|nauruan|tereno|temne|birman|lezghien|maltais|perse, vieux (ca. 600-400 av. J.-C.)|malais|marathe|vieux fran\u00e7ais (842-ca.1400)|moldave|fran\u00e7ais moyen (ca.1400-1600)|mongol|jud\u00e9o-arabe|malayalam|mac\u00e9donien|maori|marshall|malgache|marwari|braj|slave|letton|luba-katanga|delaware|lituanien|lao|lingala|limbourgeois|ewondo|ganda|luxembourgeois|latin|jud\u00e9o-persan|vote|sino-tib\u00e9taines (autre)|kirghize|cornique|komi|kurde|sioux, langues|kashmiri|kanouri|awadhi|cor\u00e9en|kannada|khmer|groenlandais|kazakh|tsigane|kuanyama|sidamo|kikuyu|kongo|norrois, vieux|g\u00e9orgien|creek|romanes (autre)|noga\u00ef, nogay|mounda, langues|langues multiples|javanais|gilbertais|zande|chan|fon|kalmouk|langues australiennes|khotanais|japonais|khoisan (autre)|palau|cheyenne|tha\u00ef (autre)|inuktitut|papiamento|italien|langues des signes|islandais|khasi|cherokee|pampanga|pahlavi|chippewyan|ido|choctaw|jargon chinook|mari|touva|bantou|pangasinan|inupiaq|chuuk|yi de Sichuan|hawa\u00efen|lamba|igbo|jagataic|irlandais ancien (jusqu\u2019\u00e0 900)|papoues (autre)|interlingue|indon\u00e9sien|lahnda|dayak|chibcha|interlingua|ladino|h\u00e9r\u00e9ro|haida|dargwa|arm\u00e9nien|langues athapascanes|hongrois|ha\u00eftien|dakota|croate|hiri motu|hindi|dyula|h\u00e9breu|asturien|haoussa|sorabes, langues|manx|goudjrati|s\u00e9mitiques (autre)|selkoupe|langues iroquoiennes|guarani|galicien|arawak|gu\u00e8ze|artificielle (autre)|ga\u00e9lique \u00e9cossais|iranien|irlandais|arapaho|araukan|frison|pieds-noirs|germanique (autre)|yupik, langues|aram\u00e9en|fran\u00e7ais|f\u00e9ro\u00efen|langue celtique (autre)|fidjien|finnois|peul|tuvalu|cebuano|persan|basque|\u00e9cossais|estonien|espagnol|esp\u00e9ranto|anglais|grec|alta\u00efques (autre)|niu\u00e9|tupi, langues|\u00e9w\u00e9|tumbuka|mossi|dzongkha|nig\u00e9ro-congolaise (autre)|lushai|langue finno-ougrienne (autre)|maldivien|nias|mohawk|luo|lunda|langues apaches|luiseno|hupa|bini|allemand|luba-lulua|bikol|washo|ind\u00e9termin\u00e9e|waray|danois|n\u00e9erlandais moyen (ca. 1050-1350)|walamo|manobo, langues|wakashennes, langues|santal|gallois|sasak|kabardine|tchouvache|slavon d\u2019\u00e9glise|manipuri|tch\u00e8que|samaritain|cree|salisha, langues|douala|corse|indiennes d\u2019Am\u00e9rique du Sud (autre)|mandchou|iakoute|kawi|ingouche|gbaya|sandawe|chamorro|langue indo-europ\u00e9enne (autre)|bhojpuri|anglais moyen (1100-1500)|karen|langue indo-aryenne (autre)|tch\u00e9tch\u00e8ne|gayo|catalan|umbundu|syriaque|kamba|tsimshian|vieil anglais (ca.450-1100)|kachin|langue caucasienne (autre)|kabyle|kara-kalpak|bosniaque|caribe|breton|tib\u00e9tain|bengali|bambara|ga|indien d\u2019Am\u00e9rique Centrale (autre)|bichlamar|bihari|bulgare|bi\u00e9lorusse|caddo|bachkir|zoulou|zenaga|proven\u00e7al ancien (jusqu\u2019\u00e0 1500)|haut-sorabe|az\u00e9ri|aymara|avar|assamais|bas-sorabe|arabe|iloko|\u00e9lamite|chinois|aragonais|pr\u00e2krit|amharique|newari|akan|zhuang|afrikaans|avestique|abkhaze|afar|yoruba|langues algiques|al\u00e9oute|mon-khmer (autre)|yiddish|langue dravidienne (autre)|berb\u00e8re|bas allemand, bas saxon|bemba|bedja|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "R\u00e9vis\u00e9";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currencyFormat", "#,##0.00 \u00a4;-#,##0.00 \u00a4" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "d MMM yy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "EEEE d MMMM yyyy" },
    { "fullTimeFormat", "HH' h 'mm z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
