(in-package "CLUEI")

; "window-doc"	;; pointer documentation window support
(in-package "XLIB")

(export '(window-documentation
	  change-window-documentation))

; "event-parse"	;; Utilities for event translation
(in-package "CLUEI")

(export '(check-function))

; "defcontact"	;; CLOS extension for resources and type conversion
(export '(defcontact))

; "intrinsics"	;; The "guts"
(export '(display-root ;; Setf'able
	  display-root-list
	  display-multipress-delay-limit
	  display-multipress-verify-p
	  *default-host*
	  *default-display*
	  *default-multipress-delay-limit*
	  *default-multipress-verify-p* 	  

	  *parent*				; Bound during contact initialization
	  open-contact-display
	  
	  basic-contact
	  contact
	  make-contact
	  ;; Contact slots:
	  display
	  parent
	  complete-name
	  complete-class
	  callbacks
	  event-translations
	  state
	  sensitive
	  compress-motion
	  compress-exposures
	  x y width height
	  border-width
	  background
	  depth
	  event-mask
	  id
	  plist
	  
	  ;; Contact slot accessors:
	  contact-background
	  contact-border-width
	  contact-callbacks
	  contact-compress-exposures
	  contact-compress-motion
	  contact-depth
	  contact-display
	  contact-event-mask
	  contact-height
	  contact-parent
	  contact-sensitive
	  contact-state
	  contact-width
	  contact-x
	  contact-y
	  
	  composite
	  children focus shells
	  composite-children
	  composite-focus
	  composite-shells
	  
	  destroy
	  
	  contact-complete-name
	  contact-complete-class
	  contact-name
	  display-name
	  display-class
;;	  find-contact
	  ancestor-p
	  realized-p
	  destroyed-p
	  mapped-p
	  top-level-p
	  managed-p
	  sensitive-p
	  event-mask  ;; Setf'able
	  resource
	  update-state
	  initialize-geometry 
	  present
	  dismiss
	  realize
	  display
	  refresh
	  owns-focus-p
	  inside-contact-p

	  add-callback
	  apply-callback
	  apply-callback-else
	  callback-p
	  delete-callback 
	  
	  root
	  contact-root
	  contact-screen
	  contact-translate
	  contact-top-level

	  read-character
	  unread-character
	  listen-character
	  append-characters
	  clear-characters
	  
	  add-child
	  delete-child
	  previous-sibling
	  next-sibling
	  change-priority
	  manage-priority
	  accept-focus-p
	  move-focus
	  change-layout
	  while-changing-layout
	  change-geometry
	  preferred-size
	  move
	  resize
	  manage-geometry

	  
	  spring-loaded
	  shadow-width

	  contact-constraints
	  contact-constraint
	  class-constraints

	  display-cursor
	  contact-image-cursor
	  contact-glyph-cursor
	  ))

; "caches"	;; Support for gcontext, pixmap, cursor cacheing
(export '(contact-mask
	  contact-image-mask
	  contact-image-pixmap
	  contact-pixmap
	  display-mask
	  display-pixmap
	  using-gcontext))

; "resource"	;; Resource and type conversion
(export '(*database*
	   convert
	   define-resources
	   undefine-resources))

(export '(default-resources ;; Debug aids
	  class-resources
	  describe-resource))

; "gray"	;; Gray stipple patterns
(export '(defimage 0%gray 6%grayr 6%gray 12%grayr 12%gray 25%grayr 25%gray 37%grayr 37%gray
	  33%gray 50%grayr 50%gray 66%gray 62%grayr 62%gray 75%grayr 75%grayh 75%gray
	  88%grayr 88%gray 93%grayr 93%gray 100%gray))

; "cursor"	;; Standard cursor names
(export '(x-cursor
	  arrow-cursor
	  based-arrow-down-cursor
	  based-arrow-up-cursor
	  boat-cursor
	  bogosity-cursor
	  bottom-left-corner-cursor
	  bottom-right-corner-cursor
	  bottom-side-cursor
	  bottom-tee-cursor
	  box-spiral-cursor
	  center-ptr-cursor
	  circle-cursor
	  clock-cursor
	  coffee-mug-cursor
	  cross-cursor
	  cross-reverse-cursor
	  crosshair-cursor
	  diamond-cross-cursor
	  dot-cursor
	  dotbox-cursor
	  double-arrow-cursor
	  draft-large-cursor
	  draft-small-cursor
	  draped-box-cursor
	  exchange-cursor
	  fleur-cursor
	  gobbler-cursor
	  gumby-cursor
	  hand1-cursor
	  hand2-cursor
	  heart-cursor
	  icon-cursor
	  iron-cross-cursor
	  left-ptr-cursor
	  left-side-cursor
	  left-tee-cursor
	  leftbutton-cursor
	  ll-angle-cursor
	  lr-angle-cursor
	  man-cursor
	  middlebutton-cursor
	  mouse-cursor
	  pencil-cursor
	  pirate-cursor
	  plus-cursor
	  question-arrow-cursor
	  right-ptr-cursor
	  right-side-cursor
	  right-tee-cursor
	  rightbutton-cursor
	  rtl-logo-cursor
	  sailboat-cursor
	  sb-down-arrow-cursor
	  sb-h-double-arrow-cursor
	  sb-left-arrow-cursor
	  sb-right-arrow-cursor
	  sb-up-arrow-cursor
	  sb-v-double-arrow-cursor
	  shuttle-cursor
	  sizing-cursor
	  spider-cursor
	  spraycan-cursor
	  star-cursor
	  target-cursor
	  tcross-cursor
	  top-left-arrow-cursor
	  top-left-corner-cursor
	  top-right-corner-cursor
	  top-side-cursor
	  top-tee-cursor
	  trek-cursor
	  ul-angle-cursor
	  umbrella-cursor
	  ur-angle-cursor
	  watch-cursor
	  i-bar-cursor))

; "events"	;; Event handling
(export '(event
	  ;; Event slots
	  key display contact character keysym above-sibling
	  atom border-width child code colormap configure-p count data
	  drawable event-window focus-p format height hint-p installed-p
	  keymap kind major minor mode name new-p override-redirect-p
	  parent place property requestor root root-x root-y same-screen-p
	  selection send-event-p state target time type width window x y

	  mode-type	   	  
	  *remap-events*
	  *restrict-events*
	  add-mode
	  delete-mode
	  with-mode
	  with-event-mode
	  contact-mode
	  contact-super-mode

	  *contact*
	  apply-action
	  call-action
	  defaction
	  describe-action
	  eval-action
	  ignore-action 
	  perform-callback
	  throw-action
	  trace-action
	  with-event
	  processing-event-p 
	  
	  add-before-action
	  delete-before-action
	  process-all-events
	  process-next-event
	  handle-event
	  translate-event
	  defevent
	  undefevent
	  event-actions
	  add-event
	  delete-event
	  describe-event-translations
	  add-timer
	  delete-timer
	  ))

; "virtual"	;; Support for windowless contacts
(export '(virtual
	  virtual-composite))

(export '(rectangle glyphs clear))

; "shells"	;; Support for top-level window/session mgr interaction
(export '(contact-root-shell 
	  override-shell
	  shell
	  shell-mapped
	  shell-owner
	  shell-unmapped
	  sm-client-host
	  sm-command
	  top-level-session
	  top-level-shell
	  transient-shell
	  with-wm-properties
	  with-wm-properties 
	  wm-base-height
	  wm-base-width
	  wm-colormap-owners
	  wm-delta-height
	  wm-delta-width
	  wm-gravity
	  wm-group
	  wm-icon
	  wm-icon-mask
	  wm-icon-title
	  wm-icon-x
	  wm-icon-y
	  wm-initial-state
	  wm-keyboard-input
	  wm-max-aspect
	  wm-max-height
	  wm-max-width
	  wm-message 
	  wm-message-protocol
	  wm-message-timestamp
	  wm-min-aspect
	  wm-min-height
	  wm-min-width
	  wm-protocols-used
	  wm-shell    
	  wm-title
	  wm-user-specified-position-p
	  wm-user-specified-size-p))

; "root-gmgmt"	;; Geometry management methods for root contacts



