;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Sound Examples
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/sound-examples.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 07/22/92 10:48:23
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

(proclaim '(special *display*
	            sound-1 sound-2 sound-3
	            sound-window
	            sound-button-1 sound-button-2 sound-button-3
	            sound-button-4 sound-menu sound-property-sheet))

(setq sound-window
      (make-window 'intel-example-window
		   :name :sound-examples
		   :x 400 :y 200 :width 200 :height 220
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Sounds")
		   :title "Sounds"))

(setq sound-1 (make-instance 'sound-dispel
		:sound "whistle"
		:repetition 2))

(setq sound-button-1 (make-window 'soft-button :parent sound-window
			  :x 20 :y 40
			  :view-of sound-1
			  :action '(call :view-of play)
			  :action-docu "Play sound"
			  :reactivity-entries
			  '((:menu
			     "Change sound properties"
			     (call :eval
				   (popup-for sound-property-sheet
					      (view-of *self*)))))
			  :bitmap-part '(:bitmap "button-l")
			  :text-part   '(:font (:face :bold)
					 :text "Sound 1")))

(setq sound-2 (make-instance 'sound-dispel
		:sound "cuckoo"
		:repetition 3))

(setq sound-button-2 (make-window 'soft-button :parent sound-window
			  :x 20 :y 80
			  :view-of sound-2
			  :action '(call :view-of play)
			  :action-docu "Play sound"
			  :reactivity-entries
			  '((:menu
			     "Change sound properties"
			     (call :eval
				   (popup-for sound-property-sheet
					      (view-of *self*)))))
			  :bitmap-part '(:bitmap "button-l")
			  :text-part   '(:font (:face :bold)
					 :text "Sound 2")))

(setq sound-3 (make-instance 'sound-dispel
		:sound "flush"
		:repetition 1))

(setq sound-button-3 (make-window 'soft-button :parent sound-window
			  :x 20 :y 120
			  :view-of sound-3
			  :action '(call :view-of play)
			  :action-docu "Play sound"
			  :reactivity-entries
			  '((:menu
			     "Change sound properties"
			     (call :eval
				   (popup-for sound-property-sheet
					      (view-of *self*)))))
			  :bitmap-part '(:bitmap "button-l")
			  :text-part   '(:font (:face :bold)
					 :text "Sound 3")))

(setq sound-menu
    (make-window 'shadow-borders-popup-container
		 :client-window
		 '(text-menu
		   :layouter (multiline-distance-layouter
			      :items-per-line 8
			      :line-offset 80)
		   :reactivity-entries
		   ((:part-event
		     (call :part-of hide)
		     (call :eval
		      (setf (sound (view-of *self*))
			  *part-value*))))
		   :parts ((:text "bark"
			    :view-of "bark")
			   (:text "bong"
			    :view-of "bong")
			   (:text "bubbles"
			    :view-of "bubbles")
			   (:text "busy"
			    :view-of "busy")
			   (:text "cirp"
			    :view-of "cirp")
			   (:text "clink"
			    :view-of "clink")
			   (:text "computer"
			    :view-of "computer")
			   (:text "cowbell"
			    :view-of "cowbell")
			   (:text "crash"
			    :view-of "crash")
			   (:text "cuckoo"
			    :view-of "cuckoo")
			   (:text "dialtone"
			    :view-of "dialtone")
			   (:text "doorbell"
			    :view-of "doorbell")
			   (:text "drip"
			    :view-of "drip")
			   (:text "flush"
			    :view-of "flush")
			   (:text "gong"
			    :view-of "gong")
			   (:text "laugh"
			    :view-of "laugh")
			   (:text "laughter"
			    :view-of "laughter")
			   (:text "ring"
			    :view-of "ring")
			   (:text "rooster"
			    :view-of "rooster")
			   (:text "sample"
			    :view-of "sample")
			   (:text "spacemusic"
			    :view-of "spacemusic")
			   (:text "splat"
			    :view-of "splat")
			   (:text "train"
			    :view-of "train")
			   (:text "whistle"
			    :view-of "whistle")))))
			  
		 

(setq sound-property-sheet
    (make-window 'shadow-popup-property-sheet
		 :view-of sound-1
		 :border-width 1
		 :reactivity-entries
		 '((:shift-left-button "Read values" (call :read))

		   (:shift-right-button "Write values" (call :write)))
		 :parts `((:class text-property-field
			   :label "sound"
			   :read-function sound
			   :write-transformation string
			   :value-part
			   (:reactivity-entries
			    ((:menu "Select sound from menu"
			      (call :eval (hide (part-of *self* 2)))
			      (call :eval
				    (popup-for sound-menu
					       (view-of *self*)))))))
			  
			  (:label "repetition"
			   :read-function repetition
			   :value-part
			   (:class text-switch
			    :border-width 1
			    :inside-border 5
			    :reactivity-entries
			    ((:single-left-button
			      "Increment repetitions"
			      (call :self switch-forward))
			     (:single-right-button
			      "Decrement repetitions"
			      (call :self switch-backward)))
			    :parts ((:view-of 1 :text "1")
				    (:view-of 2 :text "2")
				    (:view-of 3 :text "3")
				    (:view-of 4 :text "4")
				    (:view-of 5 :text "5")
				    (:view-of 6 :text "6")
				    (:view-of 7 :text "7")
				    (:view-of 8 :text "8")
				    (:view-of 9 :text "9")
				    (:view-of 10 :text "10"))))
			  )))

(setq sound-button-4 (make-window 'soft-button :parent sound-window
			  :x 20 :y 180
			  :view-of (list sound-1 sound-2 sound-3)
			  :action '(call :view-of
				    play-sound-dispels-compressed)
			  :action-docu "Play all sounds"
			  :bitmap-part '(:bitmap "button-l")
			  :text-part   '(:font (:face :bold)
					 :text "Play All")))
			    

(update-state *display*)
(process-all-events *display*)

(shrink sound-window)

(update-state *display*)
(process-all-events *display*)
