;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Example Initialization
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/start-demo.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 12/09/92 09:47:59
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;; 10/07/1991 (Hubertus) used (load-system :xit-examples) to start demo.
;;;
;;;_____________________________________________________________________________

(in-package :xit)

(format t "~&Start Time: ~A" (multiple-value-list (get-decoded-time)))

(unless *default-host* (query-x-server-host))

(format t "~%--------- ~A is the X Server host ----------~%" *default-host*)

(open-toplevel-display "XIT Demo")
(make-toplevel :shell-title "XIT Demo")

(pmds::load-system :xit-examples)

(load (system-pathname :xit-utilities "system-menu"))
(load (system-pathname :xit-utilities "identifier"))
(load (system-pathname :xit-utilities "mouse-documentation"))

(update-state *display*)
(process-all-events *display*)
(display-finish-output *display*)

(format t "~%-------------------- XIT examples are loaded -------------------------~%")
(format t "~&End Time: ~A" (multiple-value-list (get-decoded-time)))
(format t "~%Enter one of ~%~% (1) xit::toplevel-loop ~% (2) xit::eval-toplevel-loop ~% (3) :loop ~%~%to start event loop.~%")

;(eval-toplevel-loop)



