// To compile this code:
//    Move it to the current directory
//    Run "Command prompt"
//    cd to the current directory
//    type "javac -classpath lib\java test.java"
//
// then, inside of Electric's Java interpreter, type:
//    test.ex1
//    test.ex2
//    test.ex3
//    test.ex4
//    test.doVoid/Boolean/Byte/Char/Short/Int/Long/Float/Double/String

import COM.staticfreesoft.*;

class test
{
	public static Object ex1()
	{
		/* create a facet called "tran-contact" in the current library */
		electric.nodeproto myfacet = electric.newNodeProto("tran-contact", electric.curLib());

        /* get pointers to primitives */
		electric.nodeproto tran = electric.getNodeProto("P-Transistor");
		electric.nodeproto contact = electric.getNodeProto("Metal-1-Polysilicon-1-Con");

        /* get default sizes of these primitives */
		int tlowx = ((Integer)electric.getVal(tran, "lowx")).intValue();
		int thighx = ((Integer)electric.getVal(tran, "highx")).intValue();
		int tlowy = ((Integer)electric.getVal(tran, "lowy")).intValue();
		int thighy = ((Integer)electric.getVal(tran, "highy")).intValue();
		int clowx = ((Integer)electric.getVal(contact, "lowx")).intValue();
		int chighx = ((Integer)electric.getVal(contact, "highx")).intValue();
		int clowy = ((Integer)electric.getVal(contact, "lowy")).intValue();
		int chighy = ((Integer)electric.getVal(contact, "highy")).intValue();

        /* get pointer to Polysilicon arc and its default width */
		electric.arcproto arctype = electric.getArcProto("Polysilicon-1");
		int width = ((Integer)electric.getVal(arctype, "nominalwidth")).intValue();

        /* create the transistor and the contact to its left */
		electric.nodeinst c1 = electric.newNodeInst(contact, clowx, chighx, clowy, chighy,
			0, 0, myfacet);
		electric.nodeinst t1 = electric.newNodeInst(tran, tlowx+8000, thighx+8000,
			tlowy, thighy, 0, 0, myfacet);

		/* get the transistor's left port coordinates */
		electric.portproto tport = electric.getPortProto(tran, "p-trans-poly-left");
		Integer[] tpos = electric.portPosition(t1, tport);

		/* get the contacts's only port coordinates */
		electric.portproto cport = (electric.portproto)electric.getVal(contact, "firstportproto");
		Integer[] cpos = electric.portPosition(c1, cport);

		/* run a wire between the primitives */
		electric.arcinst ai = electric.newArcInst(arctype, width, 0,
			t1, tport, tpos[0].intValue(), tpos[1].intValue(),
			c1, cport, cpos[0].intValue(), cpos[1].intValue(), myfacet);

		/* make ports on the transistor */
		electric.portproto topport = electric.getPortProto(tran, "p-trans-diff-top");
		electric.portproto botport = electric.getPortProto(tran, "p-trans-diff-bottom");
		electric.portproto p1 = electric.newPortProto(myfacet, t1, topport, "topdiff");
		electric.portproto p2 = electric.newPortProto(myfacet, t1, botport, "botdiff");

		/* name the arc */
		electric.setVal(ai, "ARC_name", "Connection", electric.vdisplay);
 
        /* create a pure-layer node with outline information */
		electric.nodeproto m1node = electric.getNodeProto("Metal-1-Node");
		electric.nodeinst mn = electric.newNodeInst(m1node, 3000, 5000, 2000, 4000,
			0, 0, myfacet);
		int[] outline = new int[8];
		outline[0] = -1000;   outline[1] = 0;
		outline[2] = 0;       outline[3] = 1000;
		outline[4] = 1000;    outline[5] = 0;
		outline[6] = 0;       outline[7] = -1000;
		electric.setVal(mn, "trace", outline, 0);

		System.out.println("Created the facet 'tran-contact'");
		return(myfacet);
	}

	public static Object ex2()
	{
		/* create a facet called "two-trans" */
		electric.nodeproto higherfacet = electric.newNodeProto("two-trans", electric.curLib());

		/* get pointer to the "tran-contact" facet */
		electric.nodeproto tc = electric.getNodeProto("tran-contact");

		/* get size of this facet */
		int lowx = ((Integer)electric.getVal(tc, "lowx")).intValue();
		int highx = ((Integer)electric.getVal(tc, "highx")).intValue();
		int lowy = ((Integer)electric.getVal(tc, "lowy")).intValue();
		int highy = ((Integer)electric.getVal(tc, "highy")).intValue();

		/* create the two facet instances, one above the other */
		electric.nodeinst o1 = electric.newNodeInst(tc, lowx, highx, lowy, highy,
			0, 0, higherfacet);
		electric.nodeinst o2 = electric.newNodeInst(tc, lowx, highx, lowy+10000, highy+10000,
			0, 0, higherfacet);

		/* get pointer to P-Active arc and its default width */
		electric.arcproto darctype = electric.getArcProto("P-Active");
		int dwidth = ((Integer)electric.getVal(darctype, "nominalwidth")).intValue();

		/* get the bottom facet's top port */
		electric.portproto lowport = electric.getPortProto(tc, "topdiff");
		Integer[] lowpos = electric.portPosition(o1, lowport);

		/* get the top facet's bottom port */
		electric.portproto highport = electric.getPortProto(tc, "botdiff");
		Integer[] highpos = electric.portPosition(o2, highport);

		/* run a wire between the primitives */
		electric.arcinst ai = electric.newArcInst(darctype, dwidth, 0,
			o1, lowport, lowpos[0].intValue(), lowpos[1].intValue(),
			o2, highport, highpos[0].intValue(), highpos[1].intValue(), higherfacet);

		System.out.println("Created the facet 'two-trans'");

		/* invoke the "help" command */
		electric.aid user = electric.getAid("user");
		String[] message = new String[2];
		message[0] = "show";
		message[1] = "technologies";
		electric.tellAid(user, 2, message);
		return(higherfacet);
	}

	public static String describenode(electric.nodeinst node)
	{
		electric.nodeproto proto = (electric.nodeproto)electric.getVal(node, "proto");
		int primindex = ((Integer)electric.getVal(proto, "primindex")).intValue();
		if (primindex == 0)
		{
			return( (String) electric.getVal( (electric.cell)electric.getVal(proto, "cell"), "cellname"));
		}
		return((String)electric.getVal(proto, "primname"));
	}

	public static void ex3()
	{
		electric.nodeinst ni;
		electric.nodeproto myfacet = electric.getNodeProto("tran-contact");

		for(ni = (electric.nodeinst)electric.getVal(myfacet, "firstnodeinst");
			!ni.isNull();
			ni = (electric.nodeinst)electric.getVal(ni, "nextnodeinst"))
		{
			System.out.println("Found node " + describenode(ni));
		}
	}

	public static void ex4()
	{
		electric.nodeproto myfacet = electric.getNodeProto("tran-contact");
		int key = electric.initSearch(2000, 10000, -3000, 3000, myfacet);
		for(;;)
		{
			electric.geom object = (electric.geom)electric.nextObject(key);
			if (object.isNull()) break;
			int type = ((Integer)electric.getVal(object, "entrytype")).intValue();
			if (type == 1)
			{
				electric.nodeinst ni = (electric.nodeinst)electric.getVal(object, "entryaddr");
				System.out.println("Found node " + describenode(ni));
			} else
			{
				electric.arcinst ai = (electric.arcinst)electric.getVal(object, "entryaddr");
				String arcname = (String)electric.getVal((electric.arcproto)electric.getVal(ai, "proto"), "protoname");
				System.out.println("Found arc " + arcname);
			}
		}
	}

	public static void    doVoid() {}
	public static boolean doBoolean() { return(true); }
	public static byte    doByte() { return(24); }
	public static char    doChar() { return('A'); }
	public static short   doShort() { return(5000); }
	public static int     doInt() { return(2000000); }
	public static long    doLong() { return(123456789); }
	public static float   doFloat() { return(3.14159f); }
	public static double  doDouble() { return(3.1415926535); }
	public static String  doString() { return("Howdy"); }
	public static void    doExit() { System.exit(12); }
}
