/*
  GNU Gama C++ library tests/statan
  Copyright (C) 2018  Ales Cepek <cepek@gnu.org>

  This file is part of the GNU Gama C++ library
  
  GNU Gama is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  GNU Gama is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Gama.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <vector>
#include <cmath>
#include "gnu_gama/statan.h"

using namespace GNU_gama;
using namespace std;

/*
  Testing data generated from the Octave script:

  % student distribution - critical values

  % degrees of freedom
  dof = [1 2 3 4 5 10 20 30 50 100];

  N = 100;
  M = 80;
  x = N-1:-1:M;

  printf('  std::vector<double> X = {\n');
  printf('    %6.3f,\n', x/N);
  printf('  };\n\n');

  for i = dof
  c = tinv(x/N, i);
  
  printf('{\n');
  printf('  std::vector<double> Y = {\n');
  printf('    %20.16f,\n', c);
  printf('  };\n\n');
  printf('  int dof = %d;\n', i);
  printf('  max_avg(dof, X, Y);\n');
  printf('}\n\n');
  endfor

*/

/* 
   R language

   x <- c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)/100

   > qt(1-x,1)
    [1] 31.820516 15.894545 10.578895  7.915815  6.313752  5.242184  4.473743
    [8]  3.894743  3.442023  3.077684  2.777607  2.525712  2.310864  2.125108
   [15]  1.962611  1.818993  1.690908  1.575748  1.471455  1.376382
   > qt(1-x,2)
    [1] 6.964557 4.848732 3.896425 3.319764 2.919986 2.620162 2.383378 2.189401
    [9] 2.026081 1.885618 1.762740 1.653738 1.555913 1.467250 1.386207 1.311578
   [17] 1.242411 1.177936 1.117525 1.060660
   > qt(1-x,3)
    [1] 4.5407029 3.4819088 2.9505105 2.6054268 2.3533634 2.1562392 1.9950221
    [8] 1.8589282 1.7412966 1.6377444 1.5452445 1.4616246 1.3852761 1.3149770
   [15] 1.2497781 1.1889286 1.1318248 1.0779740 1.0269698 0.9784723
   > qt(1-x,4)
    [1] 3.7469474 2.9985279 2.6007620 2.3328726 2.1318468 1.9712325 1.8375235
    [8] 1.7229325 1.6225780 1.5332063 1.4525448 1.3789458 1.3111780 1.2482978
   [15] 1.1895669 1.1343966 1.0823107 1.0329180 0.9858936 0.9409646
   > qt(1-x,5)
    [1] 3.3649300 2.7565085 2.4215847 2.1909583 2.0150484 1.8726778 1.7528902
    [8] 1.6493004 1.5578693 1.4758840 1.4014361 1.3331333 1.2699294 1.2110186
   [15] 1.1557673 1.1036683 1.0543091 1.0073501 0.9625079 0.9195438
   > qt(1-x,10)
    [1] 2.7637695 2.3593146 2.1202335 1.9480995 1.8124611 1.6998409 1.6030754
    [8] 1.5178980 1.4415595 1.3721836 1.3084323 1.2493167 1.1940856 1.1421541
   [15] 1.0930581 1.0464226 1.0019404 0.9593564 0.9184561 0.8790578
   > qt(1-x,20)
    [1] 2.5279770 2.1966577 1.9937126 1.8443309 1.7247182 1.6241512 1.5368521
    [8] 1.4593414 1.3893565 1.3253407 1.2661759 1.2110309 1.1592705 1.1103976
   [15] 1.0640158 1.0198036 0.9774963 0.9368734 0.8977489 0.8599644
   > qt(1-x,30)
    [1] 2.4572615 2.1469663 1.9546455 1.8120471 1.6972609 1.6003530 1.5159466
    [8] 1.4407918 1.3727687 1.3104150 1.2526780 1.1987733 1.1481004 1.1001888
   [15] 1.0546623 1.0112157 0.9695973 0.9295969 0.8910373 0.8537673
   > qt(1-x,50)
    [1] 2.4032719 2.1087213 1.9244369 1.7870012 1.6759050 1.5818045 1.4996240
    [8] 1.4262866 1.3597800 1.2987137 1.2420843 1.1891434 1.1393168 1.0921541
   [15] 1.0472949 1.0044462 0.9633663 0.9238530 0.8857359 0.8488692
   > qt(1-x,100)
    [1] 2.3642174 2.0808839 1.9023697 1.7686589 1.6602343 1.5681720 1.4876112
    [8] 1.4155986 1.3501996 1.2900748 1.2342566 1.1820222 1.1328168 1.0862044
   [15] 1.0418359 0.9994273 0.9587440 0.9195900 0.8817993 0.8452304

*/

double MAX = 0;

void max_avg(int dof, vector<double>& X, vector<double>& Y)
{
  double max = 0, sum = 0, diff {};
  for (std::size_t i=0; i<X.size(); i++) {
    diff = Student(1 - X[i], dof) - Y[i];
    sum += diff;
    if (abs(diff) > abs(max)) max = diff;
  }
  sum /= X.size();
  cout << "Student distribution - critical values" << endl;
  cout << "degrees of freedom = " << dof << endl;
  cout << "diff max = " << max << "  avg = " << sum << "\n\n";

  if (abs(max) > abs(MAX)) MAX = max;
}

int main()
{
  std::vector<double> X = {
     0.990,
     0.980,
     0.970,
     0.960,
     0.950,
     0.940,
     0.930,
     0.920,
     0.910,
     0.900,
     0.890,
     0.880,
     0.870,
     0.860,
     0.850,
     0.840,
     0.830,
     0.820,
     0.810,
     0.800,
  };

{
  std::vector<double> Y = {
     31.8205159537764857,
     15.8945448438652850,
     10.5788949934056244,
      7.9158150883058180,
      6.3137515146750340,
      5.2421835811131725,
      4.4737428292115577,
      3.8947428549298619,
      3.4420225766692183,
      3.0776835371752531,
      2.7776068539149752,
      2.5257116894473048,
      2.3108636538824108,
      2.1251081731572019,
      1.9626105055051497,
      1.8189932472810653,
      1.6909076557850096,
      1.5757478599686501,
      1.4714553158199690,
      1.3763819204711736,
  };

  int dof = 1;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      6.9645567342832706,
      4.8487322138506084,
      3.8964253597614857,
      3.3197640478403461,
      2.9199855803537238,
      2.6201618703718186,
      2.3833781805368823,
      2.1894013475992851,
      2.0260814655403436,
      1.8856180831641267,
      1.7627399973517184,
      1.6537377315791295,
      1.5559133940653656,
      1.4672504626906002,
      1.3862065601673439,
      1.3115784746777808,
      1.2424114089714613,
      1.1779362781316967,
      1.1175253455674758,
      1.0606601717798210,
  };

  int dof = 2;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      4.5407028585681326,
      3.4819087603212124,
      2.9505104700829277,
      2.6054268230772144,
      2.3533634348018233,
      2.1562391883828980,
      1.9950220773915699,
      1.8589281910254338,
      1.7412965686469553,
      1.6377443536962097,
      1.5452444990018068,
      1.4616245732763162,
      1.3852761018802260,
      1.3149769634400970,
      1.2497781050332248,
      1.1889286364770162,
      1.1318247629868099,
      1.0779740402996056,
      1.0269697742530817,
      0.9784723123633050,
  };

  int dof = 3;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      3.7469473879791959,
      2.9985278732065854,
      2.6007619950497745,
      2.3328725604509901,
      2.1318467863266495,
      1.9712324646690005,
      1.8375235149448677,
      1.7229325481642046,
      1.6225779656636021,
      1.5332062740589445,
      1.4525447932518287,
      1.3789457914547587,
      1.3111779582625098,
      1.2482977903919308,
      1.1895668524436938,
      1.1343966379740464,
      1.0823107045392795,
      1.0329179902584666,
      0.9858935819896529,
      0.9409645772351811,
  };

  int dof = 4;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      3.3649299989072179,
      2.7565085219094740,
      2.4215847093953267,
      2.1909582571811845,
      2.0150483733330238,
      1.8726777590753605,
      1.7528901578754872,
      1.6493003537134072,
      1.5578693498253864,
      1.4758840488244813,
      1.4014360927479614,
      1.3331332832720180,
      1.2699294017053937,
      1.2110186420939761,
      1.1557673428942934,
      1.1036682729560623,
      1.0543090992971405,
      1.0073500745032058,
      0.9625078930231855,
      0.9195437802408264,
  };

  int dof = 5;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      2.7637694581126957,
      2.3593146237365352,
      2.1202335338011027,
      1.9480994688714979,
      1.8124611228116767,
      1.6998408785322057,
      1.6030754454279110,
      1.5178979923877640,
      1.4415594541285663,
      1.3721836411103345,
      1.3084322613628419,
      1.2493166973235450,
      1.1940855553414131,
      1.1421540894929889,
      1.0930580735905258,
      1.0464226104979648,
      1.0019404233557436,
      0.9593563653545226,
      0.9184561244634303,
      0.8790578285505891,
  };

  int dof = 10;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      2.5279770027415731,
      2.1966577455526757,
      1.9937126083195260,
      1.8443309416068059,
      1.7247182429207857,
      1.6241511876853669,
      1.5368521116394016,
      1.4593414396600279,
      1.3893565033243769,
      1.3253407069850465,
      1.2661759112932869,
      1.2110309409127549,
      1.1592704816882133,
      1.1103975644468751,
      1.0640157711603981,
      1.0198035541153152,
      0.9774962810876351,
      0.9368733699390506,
      0.8977488706003661,
      0.8599644397323873,
  };

  int dof = 20;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      2.4572615424006035,
      2.1469662790897885,
      1.9546454957884551,
      1.8120471079011011,
      1.6972608865939587,
      1.6003529504963721,
      1.5159465873262337,
      1.4407917992306385,
      1.3727686937492052,
      1.3104150253913973,
      1.2526779778537753,
      1.1987733048176330,
      1.1481004357967990,
      1.1001887742509324,
      1.0546623471785603,
      1.0112157453924313,
      0.9695972767965145,
      0.9295968781519542,
      0.8910372544782932,
      0.8537672614712977,
  };

  int dof = 30;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      2.4032719166741572,
      2.1087212818962531,
      1.9244368570786248,
      1.7870012357457643,
      1.6759050251630900,
      1.5818045253822808,
      1.4996240480580727,
      1.4262865527699318,
      1.3597800262161717,
      1.2987136941948108,
      1.2420843352473117,
      1.1891434052029954,
      1.1393168144382466,
      1.0921541012626663,
      1.0472949265516827,
      1.0044462400499292,
      0.9633662729204168,
      0.9238530389372595,
      0.8857358971872825,
      0.8488692445086662,
  };

  int dof = 50;
  max_avg(dof, X, Y);
}

{
  std::vector<double> Y = {
      2.3642173662384907,
      2.0808839013370579,
      1.9023697037899368,
      1.7686589233125614,
      1.6602343260853492,
      1.5681720423985641,
      1.4876112318338144,
      1.4155986318720364,
      1.3501996103997767,
      1.2900747613465169,
      1.2342565711979849,
      1.1820222419069608,
      1.1328168077671565,
      1.0862043673587354,
      1.0418359009083447,
      0.9994273166257925,
      0.9587440463630874,
      0.9195899708257477,
      0.8817992870893966,
      0.8452304244910133,
  };

  int dof = 100;
  max_avg(dof, X, Y);
}
  
 // results from Student() function are only approximate 
 cout << "maximal diff = " << MAX << endl;
 return abs(MAX) < 1e-4 ? 0 : 1;
}
