/* Copyright (C) 1993, 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/* slzwx.h */
/* LZW filter state definition */
/* Requires strimpl.h */

typedef struct lzw_decode_s lzw_decode;
typedef struct lzw_encode_table_s lzw_encode_table;
typedef struct stream_LZW_state_s {
	stream_state_common;
		/* The following are set before initialization. */
	int InitialCodeLength;		/* decoding only */
	bool FirstBitLowOrder;		/* decoding only */
	bool BlockData;			/* decoding only */
	int EarlyChange;		/* decoding only */
		/* The following are updated dynamically. */
	uint bits;			/* buffer for input bits */
	int bits_left;			/* # of valid low bits left */
	int bytes_left;			/* # of bytes left in current block */
					/* (arbitrary large # if not GIF) */
	union _lzt {
		lzw_decode *decode;
		lzw_encode_table *encode;
	} table;
	uint next_code;			/* next code to be assigned */
	int code_size;			/* current # of bits per code */
	int prev_code;			/* previous code recognized */
					/* or assigned */
	uint prev_len;			/* length of prev_code */
	int copy_code;			/* code whose string is being */
					/* copied, -1 if none */
	uint copy_len;			/* length of copy_code */
	int copy_left;			/* amount of string left to copy */
	bool first;			/* true if no output yet */
} stream_LZW_state;
extern_st(st_LZW_state);
#define public_st_LZW_state()	/* in slzwc.c */\
  gs_public_st_ptrs1(st_LZW_state, stream_LZW_state,\
    "LZWDecode state", lzwd_enum_ptrs, lzwd_reloc_ptrs, table.decode)
#define s_LZW_set_defaults_inline(ss)\
  ((ss)->InitialCodeLength = 8,\
   (ss)->FirstBitLowOrder = false,\
   (ss)->BlockData = false,\
   (ss)->EarlyChange = 1)
extern const stream_template s_LZWD_template;
extern const stream_template s_LZWE_template;

/* Shared procedures */
void s_LZW_set_defaults(P1(stream_state *));
void s_LZW_release(P1(stream_state *));
