/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.HashCode;
import org.gnunet.util.crypto.EcdhePublicKey;
import org.gnunet.util.crypto.Ed25519;

public class EcdhePrivateKey
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] d;

    public EcdhePublicKey getPublicKey() {
        BigInteger dCoeff = this.asCoefficient();
        Ed25519 A = Ed25519.B.scalarmult(dCoeff);
        return new EcdhePublicKey(A);
    }

    public HashCode ecdh(EcdhePublicKey publicKey) {
        BigInteger dCoeff = this.asCoefficient();
        Ed25519 Q = publicKey.asPoint().scalarmult(dCoeff);
        return HashCode.hash(Q.P0.toByteArray());
    }

    public static EcdhePrivateKey createRandom() {
        SecureRandom sr = new SecureRandom();
        EcdhePrivateKey privateKey = new EcdhePrivateKey();
        privateKey.d = new byte[32];
        sr.nextBytes(privateKey.d);
        privateKey.d[31] = (byte)(privateKey.d[31] & 0xFFFFFFF8);
        privateKey.d[0] = (byte)(privateKey.d[0] & 0x7F);
        privateKey.d[0] = (byte)(privateKey.d[0] | 0x40);
        return privateKey;
    }

    public BigInteger asCoefficient() {
        return new BigInteger(1, this.d);
    }
}

