/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.security.SecureRandom;
import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.Ed25519;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcdsaPublicKey
implements Message {
    private static final Logger logger = LoggerFactory.getLogger(EcdsaPublicKey.class);
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] y;

    public EcdsaPublicKey(Ed25519 a) {
        this.y = a.encode();
    }

    public EcdsaPublicKey() {
    }

    public static EcdsaPublicKey fromString(String s) {
        EcdsaPublicKey publicKey = new EcdsaPublicKey();
        publicKey.y = new byte[32];
        if (Strings.stringToData(s, publicKey.y)) {
            return publicKey;
        }
        return null;
    }

    public static EcdsaPublicKey random() {
        SecureRandom sr = new SecureRandom();
        EcdsaPublicKey publicKey = new EcdsaPublicKey();
        sr.nextBytes(publicKey.y);
        return publicKey;
    }

    public String toString() {
        return Strings.dataToString(this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EcdsaPublicKey publicKey = (EcdsaPublicKey)o;
        return Arrays.equals(this.y, publicKey.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.y);
        return result;
    }

    public Ed25519 asPoint() {
        return Ed25519.decode(this.y);
    }
}

