/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */
#include "qa_dotprod.h"
#include "qa_float_dotprod_x86.h"
#include "qa_complex_dotprod_x86.h"
#include "qa_ccomplex_dotprod_x86.h"

CppUnit::TestSuite *
qa_dotprod_suite ()
{
  CppUnit::TestSuite *s = new CppUnit::TestSuite ("dotprod");

  s->addTest (qa_float_dotprod_x86::suite ());
  s->addTest (qa_complex_dotprod_x86::suite ());
  s->addTest (qa_ccomplex_dotprod_x86::suite ());

  return s;
}
