/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef INCLUDED_MC4020_SOURCE_H
#define INCLUDED_MC4020_SOURCE_H

#include <gr_sync_block.h>
#include <mc4020.h>
#include <mc4020_bitmask.h>
#include <string>


class mc4020_source;
typedef boost::shared_ptr<mc4020_source> mc4020_source_sptr;


// public shared_ptr constructor

mc4020_source_sptr
mc4020_make_source (double sampling_freq = 20e6,
		    unsigned long config_bitmask = MCC_CH0_EN | MCC_ALL_5V,
		    const std::string dev = "/dev/mc4020_0");

/*!
 * \brief high speed A/D source using Measurement Computing PCI-DAS4020/12
 *
 * This source includes the conversion from straight binary to 2's complement.
 */

class mc4020_source : public gr_sync_block {
 public:
  ~mc4020_source ();

  int work (int noutput_items,
	    gr_vector_const_void_star &input_items,
	    gr_vector_void_star &output_items);


 private:
  unsigned 		d_samples_per_page;
  int			d_device_fd;
  unsigned long		d_buffersize_pages;
  int			d_total_lost;
  char	       	       *d_buf;			// memory mapped i/o buffer
  struct mc4020_status	d_status;
  

  friend mc4020_source_sptr
  mc4020_make_source (double sampling_freq,
		      unsigned long config_bitmask, const std::string dev);

  mc4020_source (double sampling_freq,
		 unsigned long config_bitmask, const std::string dev);
};


#endif /* INCLUDED_MC4020_SOURCE_H */
