/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000, 2001 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include "load_data.h"
#include "gnutr_druid.h"
#include "base_win.h"

gint
main( int argc, char *argv[])
{
	gboolean exists1, exists2;
	char *home, *fn;

#ifdef ENABLE_NLS
	bindtextdomain( PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain( PACKAGE);
#endif

	gnome_init( "Gnutrition", VERSION, argc, argv);

	glade_gnome_init();

	home = g_get_home_dir();

	/* check that a config file exists in .gnutrition */
	fn = g_strconcat( home, "/.gnutrition/mysql_access.xml", NULL);
	exists1 = g_file_test( fn, G_FILE_TEST_ISFILE);
	g_free( fn);

	fn = g_strconcat( home, "/.gnutrition/person_info.xml", NULL);
	exists2 = g_file_test( fn, G_FILE_TEST_ISFILE);
	g_free( fn);

	if ( exists1 && exists2) {
		gnutr_startup();
		gnutr_show_base_win();
	} else {
		gnutr_show_druid_win();
	}

	gtk_main();

	return 0;
}
