#!/bin/bash

test -e $1 && echo "$1 already exists" && exit 1
mkdir -p $1/tmp
cd $1/tmp

wget -nd -r -q "ftp://ftp.mozilla.org/pub/firefox/releases/$1/linux-i686/xpi/*"
odir=$(pwd)
for i in *.xpi; do
  tmp_dir=$(mktemp -d)
  printf "Translating %s in %s\n" $odir/$i $tmp_dir
  (cd $tmp_dir
      unzip -q $odir/$i

      for STRING in community.start2 community.mozillaLink \
          community.middle2 community.creditsLink community.end2 \
          contribute.start contribute.getInvolvedLink contribute.end
      do
          find -wholename '*browser/aboutDialog.dtd' \
              | xargs sed "s/$STRING.*/$STRING \"\">/" -i
      done
      find -wholename '*branding/brand.dtd' \
       | xargs sed 's/trademarkInfo.part1.*/trademarkInfo.part1 "">/' -i
      find -type f -\! -name install.rdf -exec sed -i \
          -e"/trademarkInfo/n"\
          -e"/MPL/n"\
          -e"/xmlns:em/n" \
          -e"s|Mozilla Firefox|GNU IceCat|gi" -e"s|Firefox|GNU IceCat|gi" \
          -e"s|http://www.mozilla.org/|http://gnuzilla.gnu.org/|g" \{\} \;
      zip -q -r $i .)
  mv $tmp_dir/$i ..
  rm -rf $tmp_dir
  sleep 0.05s
done

rm -rf tmp
