/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Version: MPL 1.1
 *
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corp, Inc.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Stuart Parmenter <pavlov@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "xptcprivate.h"
#include "xptiprivate.h"

#include "mozilla/StandardInteger.h"

/*
 * This is for MIPS O32 ABI
 * Args contains a0-3 and then the stack.
 * Because a0 is 'this', we want to skip it
 */
extern "C" nsresult
PrepareAndDispatch(nsXPTCStubBase* self, PRUint32 methodIndex, PRUint32* args)
{
    args++; // always skip over a0

#define PARAM_BUFFER_COUNT		16

    nsXPTCMiniVariant paramBuffer[PARAM_BUFFER_COUNT];
    nsXPTCMiniVariant* dispatchParams = NULL;
    const nsXPTMethodInfo* info;
    PRUint8 paramCount;
    PRUint8 i;
    nsresult result = NS_ERROR_FAILURE;

    NS_ASSERTION(self,"no self");

    self->mEntry->GetMethodInfo(PRUint16(methodIndex), &info);
    NS_ASSERTION(info,"no method info");

    paramCount = info->GetParamCount();

    // setup variant array pointer
    if(paramCount > PARAM_BUFFER_COUNT)
        dispatchParams = new nsXPTCMiniVariant[paramCount];
    else
        dispatchParams = paramBuffer;
    NS_ASSERTION(dispatchParams,"no place for params");

    PRUint32* ap = args;
    for(i = 0; i < paramCount; i++, ap++)
    {
        const nsXPTParamInfo& param = info->GetParam(i);
        const nsXPTType& type = param.GetType();
        nsXPTCMiniVariant* dp = &dispatchParams[i];

        if(param.IsOut() || !type.IsArithmetic())
        {
            dp->val.p = (void*) *ap;
            continue;
        }

        switch(type)
        {
        case nsXPTType::T_I64   :
            if ((intptr_t)ap & 4) ap++;
            dp->val.i64 = *((PRInt64*) ap); ap++;
            break;
        case nsXPTType::T_U64   :
            if ((intptr_t)ap & 4) ap++;
            dp->val.u64 = *((PRInt64*) ap); ap++;
            break;
        case nsXPTType::T_DOUBLE:
            if ((intptr_t)ap & 4) ap++;
            dp->val.d   = *((double*) ap);  ap++;
            break;
#ifdef IS_LITTLE_ENDIAN
        default:
            dp->val.p = (void*) *ap;
            break;
#else
        case nsXPTType::T_I8    : dp->val.i8  = (PRInt8)   *ap; break;
        case nsXPTType::T_I16   : dp->val.i16 = (PRInt16)  *ap; break;
        case nsXPTType::T_I32   : dp->val.i32 = (PRInt32)  *ap; break;
        case nsXPTType::T_U8    : dp->val.u8  = (PRUint8)  *ap; break;
        case nsXPTType::T_U16   : dp->val.u16 = (PRUint16) *ap; break;
        case nsXPTType::T_U32   : dp->val.u32 = (PRUint32) *ap; break;
        case nsXPTType::T_BOOL  : dp->val.b   = (bool)   *ap; break;
        case nsXPTType::T_CHAR  : dp->val.c   = (char)     *ap; break;
        case nsXPTType::T_WCHAR : dp->val.wc  = (wchar_t)  *ap; break;
        case nsXPTType::T_FLOAT : dp->val.f   = *(float *)  ap; break;
        default:
            NS_ASSERTION(0, "bad type");
            break;
#endif
        }
    }

    result = self->mOuter->CallMethod((PRUint16)methodIndex, info, dispatchParams);

    if(dispatchParams != paramBuffer)
        delete [] dispatchParams;

    return result;
}

#define STUB_ENTRY(n) // done in the .s file

#define SENTINEL_ENTRY(n) \
nsresult nsXPTCStubBase::Sentinel##n() \
{ \
    NS_ERROR("nsXPTCStubBase::Sentinel called"); \
    return NS_ERROR_NOT_IMPLEMENTED; \
}

#include "xptcstubsdef.inc"
