/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is sessionstore test code.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Paul O’Shannessy <paul@oshannessy.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function test() {
  /** Test for Bug 490040 **/

  let ss = Cc["@mozilla.org/browser/sessionstore;1"].getService(Ci.nsISessionStore);
  let os = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);

  waitForExplicitFinish();

  function testWithState(aState, aCallback) {
    // ensure we can store the window if need be
    let curClosedWindowCount = ss.getClosedWindowCount();
    gPrefService.setIntPref("browser.sessionstore.max_windows_undo", curClosedWindowCount + 1);

    let theWin = openDialog(location, "_blank", "chrome,all,dialog=no");
    theWin.addEventListener("load", function(aEvent) {
      theWin.gBrowser.removeEventListener("load", arguments.callee, true);

      ss.setWindowState(theWin, JSON.stringify(aState.windowState), true);

      let observer = {
        QueryInterface: XPCOMUtils.generateQI([Ci.nsIObserver,
                                               Ci.nsISupportsWeakReference]),
        observe: function(aSubject, aTopic, aData) {
          let _this = this;
          // use executeSoon to ensure this happens after SS observer
          executeSoon(function() {
            is(ss.getClosedWindowCount(), curClosedWindowCount + (aState.shouldBeAdded ? 1 : 0),
               "That window should " + (aState.shouldBeAdded ? "" : "not ") + "be restorable");
            os.removeObserver(_this, "domwindowclosed");
            executeSoon(aCallback);
          });
        }
      };
      os.addObserver(observer, "domwindowclosed", true);

      theWin.gBrowser.addEventListener("load", function() {
        theWin.gBrowser.removeEventListener("load", arguments.callee, true);
        theWin.close();
      }, true);
    }, true);
  }

  // Only windows with open tabs are restorable. Windows where a lone tab is
  // detached may have _closedTabs, but is left with just an empty tab.
  let states = [
    {
      shouldBeAdded: true,
      windowState: {
        windows: [{
          tabs: [{ entries: [{ url: "http://example.com", title: "example.com" }] }],
          selected: 1,
          _closedTabs: []
        }]
      }
    },
    {
      shouldBeAdded: false,
      windowState: {
        windows: [{
          tabs: [{ entries: [] }],
          _closedTabs: []
        }]
      }
    },
    {
      shouldBeAdded: false,
      windowState: {
        windows: [{
          tabs: [{ entries: [] }],
          _closedTabs: [{ state: { entries: [{ url: "http://example.com", index: 1 }] } }]
        }]
      }
    },
    {
      shouldBeAdded: false,
      windowState: {
        windows: [{
          tabs: [{ entries: [] }],
          _closedTabs: [],
          extData: { keyname: "pi != " + Math.random() }
        }]
      }
    }
  ];

  testWithState(states[0], function() {
    testWithState(states[1], function() {
      testWithState(states[2], function() {
        testWithState(states[3], function() {
          try {
            gPrefService.clearUserPref("browser.sessionstore.max_windows_undo");
          }
          catch (e) {}
          finish();
        });
      });
    });
  });
}

