.\" -*- nroff -*-
.TH GXDITVIEW 1 "Release 4" "X Version 11"
.SH NAME
gxditview \- display gtroff output files
.SH SYNOPSIS
.B gxditview
.RI [\fB\- toolkitoption\  .\|.\|.\|]
.RI [\fB\- option\  .\|.\|.\|]
.RI [ filename ]
.SH DESCRIPTION
The
.I gxditview 
program displays gtroff output on an X display.
It uses the standard X11 fonts,
so it does not require access to the server machine for font loading.
.PP
If
.I filename
is
.BR \- ,
.I gxditview
will read the standard input.
.PP
The left mouse button brings up a menu with the following entries:
.TP 8
.B "Next Page"
Display the next page.
.TP
.B "Previous Page"
Display the previous page.
.TP
.B "Select Page"
Select a particular numbered page specified by a dialog box.
.TP
.B Print
Print the gtroff output using a command specified by a dialog box.
The default command initially displayed is controlled by the
.B printCommand
application resource, and by the
.B \-printCommand
option.
.TP
.B Open
Open for display a new file specified by a dialog box.
The file should contain gtroff output.
If the filename starts with
.B |
it will be taken to be a command to read from.
.TP
.B Quit
Exit from
.IR gxditview .
.PP
The
.B paperlength
and
.B paperwidth
commands in the DESC file specify the length and width in machine units
of the virtual page displayed by
.IR gxditview .
.SH OPTIONS
.I Gxditview
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed.
.TP
.B \-page
This option specifies the page number of the document to be displayed.
.TP
.BI \-backingStore\  backing-store-type
Redisplay of the gtroff output window can take upto a second or so,
this option causes the server to save the window contents so that when
it is scrolled around the viewport, the window is painted from
contents saved in backing store.
.I backing-store-type
can be one of
.BR Always ,
.B WhenMapped
or 
.BR NotUseful .
.TP
.BI \-printCommand\  command
The default command displayed in the dialog box for the
.B Print
menu entry will be
.IR command .
.TP
.BI \-resolution\  res
The gtroff output file will be displayed at a resolution of
.I res
dpi,
unless the DESC file contains the
.B X11
command, in which case the device resolution will be used.
This corresponds the
.I Dvi
widget's
.B resolution
resource.
The default is 75.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.IR gxditview :
.TP 8
.BI \-bg\  color
This option specifies the color to use for the background of the window.  
The default is \fIwhite\fP.
.TP
.BI \-bd\  color
This option specifies the color to use for the border of the window.
The default is \fIblack\fP.
.TP
.BI \-bw\  number
This option specifies the width in pixels of the border surrounding the window.
.TP
.BI \-fg\  color
This option specifies the color to use for displaying text.  The default is 
\fIblack\fP.
.TP
.BI \-fn\  font
This option specifies the font to be used for displaying widget text.  The
default is \fIfixed\fP.
.TP
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP
.BI \-geometry\  geometry
This option specifies the preferred size and position of the window.
.TP
.BI \-display\  host : display
This option specifies the X server to contact.
.TP
.BI \-xrm\  resourcestring
This option specifies a resource string to be used.
.SH X DEFAULTS
This program uses the 
.I Dvi
widget in the X Toolkit.  It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.BR width\  (class\  Width )
Specifies the width of the window.
.TP
.BR height\  (class\  Height )
Specifies the height of the window.
.TP
.BR foreground\  (class\  Foreground )
Specifies the default foreground color.
.TP
.BR font\  (class\  Font )
Specifies the font to be used for error messages.
.SH "SEE ALSO"
.IR X (1),
.IR xrdb (1),
.IR gtroff (1),
.IR groff (1)
.SH ORIGIN
This program is derived from xditview;
portions of xditview originated in xtroff which was derived
from suntroff.  
.SH COPYRIGHT
Copyright 1989, Massachusetts Institute of Technology.
.br
See
.IR X (1)
for a full statement of rights and permissions.
.SH AUTHORS
Keith Packard (MIT X Consortium)
.br
Richard L. Hyde (Purdue)
.br
David Slattengren (Berkeley)
.br
Malcom Slaney (Schlumberger Palo Alto Research)
.br
Mark Moraes (University of Toronto)
.br
James Clark
