.ig \"-*- nroff -*-
Copyright (C) 1989-1995 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.TH GROFF_MS @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_ms \- groff ms macros
.SH SYNOPSIS
.B groff
.B \-ms
[
.IR options .\|.\|.
]
[
.IR files .\|.\|.
]
.br
.B groff
.B \-m\ ms
[
.IR options .\|.\|.
]
[
.IR files .\|.\|.
]
.SH DESCRIPTION
This manual page describes the GNU version of the ms macros,
which is part of the groff document formatting system.
The groff ms macros are intended to be compatible with the
documented behaviour of the 4.3
.SM BSD
Unix ms macros subject to the following limitations:
.IP \(bu
the internals of groff ms are not similar to the internals of Unix ms
and so documents that depend upon implementation details of Unix ms
may well not work with groff ms;
.IP \(bu
there is no support for typewriter-like devices;
.IP \(bu
Berkeley localisms, in particular the
.B TM
and
.B CT
macros, are not implemented;
.IP \(bu
groff ms
does not provide cut marks;
.IP \(bu
multiple line spacing is not allowed
(use a larger vertical spacing instead);
.IP \(bu
groff ms does not work in compatibility mode (eg with the
.B \-C
option);
.IP \(bu
the error-handling policy of groff ms
is to detect and report errors,
rather than silently to ignore them.
.LP
The groff ms macros make use of many features of GNU troff
and therefore cannot be used with any other troff.
.LP
Bell Labs localisms are not implemented in either the
.SM BSD
ms macros or in the groff ms macros.
.LP
Some Unix ms documentation says that the
.B CW
and
.B GW
number registers can be used to control the column width and
gutter width respectively.
This is not the case.
These number registers are not used in groff ms.
.LP
Macros that cause a reset set the indent.
Macros that change the indent do not increment or decrement
the indent, but rather set it absolutely.
This can cause problems for documents that define
additional macros of their own.
The solution is to use not the
.B in
request but instead the
.B RS
and
.B RE
macros.
.LP
The number register
.B GS
is set to 1 by the groff ms macros,
but is not used by the Unix ms macros.
It is intended that documents that need to determine whether
they are being formatted with Unix ms or groff ms make use of this
number register.
.LP
Footnotes are implemented so that they can safely be used within
keeps and displays.
Automatically numbered footnotes within floating keeps are
not recommended.
It is safe to have another
.B \e**
between a
.B \e**
and the corresponding
.BR .FS ;
it is required only that each
.B .FS
occur after the corresponding
.B \e**
and that the occurrences of
.B .FS
are in the same order as the corresponding occurrences of
.BR \e** .
.LP
The strings
.B \e*{
and
.B \e*}
can be used to begin and end a superscript.
.LP
Some Unix V10 ms features are implemented.
The
.BR B ,
.BR I
and
.B BI
macros can have an optional third argument which will be printed
in the current font before the first argument.
There is a macro
.B CW
like
.B B
that changes to a constant-width font.
.LP
The following strings can be redefined to adapt the groff ms macros
to languages other than English:
.LP
.nf
.ta \w'REFERENCES'u+2n
String	Default Value
.sp .3v
REFERENCES	References
ABSTRACT	ABSTRACT
TOC	Table of Contents
MONTH1	January
MONTH2	February
MONTH3	March
MONTH4	April
MONTH5	May
MONTH6	June
MONTH7	July
MONTH8	August
MONTH9	September
MONTH10	October
MONTH11	November
MONTH12	December
.fi
.LP
The font family is reset from the string
.BR FAM ;
at initialization if this string is undefined it is set to the current
font family.
The point size, vertical spacing, and inter-paragraph spacing for footnotes
are taken from the number registers
.BR FPS ,
.BR FVS ,
and
.BR FPD ;
at initialization these are set to
.BR \en(PS-2 ,
.BR \en[FPS]+2 ,
and
.B \en(PD/2
respectively; however, if any of these registers has been defined
before initialization, it will not be set.
The hyphenation flags (as set by the
.B .hy
request) are set from the
.B HY
register;
if this has not been defined at initialization,
it will be set to 14.
.LP
Right-aligned displays are available with
.B ".DS R"
and
.BR .RD .
.LP
The following conventions are used for names of macros, strings and
number registers.
External names available to documents that use the groff ms
macros contain only uppercase letters and digits.
Internally the macros are divided into modules.
Names used only within one module are of the form
.IB module * name\fR.
Names used outside the module in which they are defined are of the form
.IB module @ name\fR.
Names associated with a particular environment are of the form
.IB environment : name;
these are used only within the
.B par
module,
and
.I name
does not have a module prefix.
Constructed names used to implement arrays are of the form
.IB array ! index\fR.
Thus the groff ms macros reserve the following names:
.IP \(bu
names containing
.BR * ;
.IP \(bu
names containing
.BR @ ;
.IP \(bu
names containing
.BR : ;
.IP \(bu
names containing only uppercase letters and digits.
.SH FILES
.B @MACRODIR@/ms.tmac
(a wrapper file for
.BR s.tmac )
.br
.B @MACRODIR@/s.tmac
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@)
.br
.BR ms (@MAN7EXT@)
