/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:expandtab:shiftwidth=2:tabstop=2:
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *   Benjamin Smedberg <benjamin@smedbergs.us>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __nsGTKRemoteService_h__
#define __nsGTKRemoteService_h__

#include "nsIRemoteService.h"

#include "nsIObserver.h"

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "nsString.h"
#include "nsInterfaceHashtable.h"

class nsIDOMWindow;
class nsIWeakReference;
class nsIWidget;

class nsGTKRemoteService : public nsIRemoteService,
                           public nsIObserver
{
public:
  // We will be a static singleton, so don't use the ordinary methods.
  NS_DECL_ISUPPORTS
  NS_DECL_NSIREMOTESERVICE
  NS_DECL_NSIOBSERVER

  nsGTKRemoteService() :
    mServerWindow(NULL) { }

private:
  ~nsGTKRemoteService() { }

  void HandleCommandsFor(GtkWidget* aWidget,
                         nsIWeakReference* aWindow);

  static void EnsureAtoms();
  static PLDHashOperator StartupHandler(const void* aKey,
                                        nsIWeakReference* aData,
                                        void* aClosure);

  static const char* HandleCommand(char* aCommand, nsIDOMWindow* aWindow,
                                   PRUint32 aTimestamp);

#ifdef MOZ_XUL_APP
  static const char* HandleCommandLine(char* aBuffer, nsIDOMWindow* aWindow,
                                       PRUint32 aTimestamp);
#endif

  static gboolean HandlePropertyChange(GtkWidget *widget,
                                       GdkEventProperty *event,
                                       nsIWeakReference* aThis);

  GtkWidget* mServerWindow;
  nsCString mAppName;
  nsCString mProfileName;
  nsInterfaceHashtable<nsVoidPtrHashKey, nsIWeakReference> mWindows;

  static Atom sMozVersionAtom;
  static Atom sMozLockAtom;
  static Atom sMozCommandAtom;
  static Atom sMozResponseAtom;
  static Atom sMozUserAtom;
  static Atom sMozProfileAtom;
  static Atom sMozProgramAtom;
  static Atom sMozCommandLineAtom;
};

#endif // __nsGTKRemoteService_h__
