<?xml version='1.0' encoding='UTF-8'?>
<!--

  Convert an ignuit flashcard file to a Granule flashcard file.
  Command line usage:

  xsltproc -novalid -o outfile.dkf Granule.xsl infile.xml

  FIXME: back_example isn't implemented.

  trm 2008-01-22

-->
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output
    method='xml'
    indent='yes'
    encoding='UTF-8'
    doctype-public='deck'
    doctype-system='http://granule.sourceforge.net/granule.dtd' />

  <xsl:strip-space elements='*' />

  <xsl:template match='front'>
    <front>
      <xsl:value-of select='.' />
    </front>
  </xsl:template>

  <xsl:template match='back'>
    <back>
      <xsl:value-of select='.' />
    </back>
    <back_example />
  </xsl:template>

  <xsl:template match='card'>
    <card>
      <xsl:attribute name='id' />
      <xsl:apply-templates select='front' />
      <xsl:apply-templates select='back' />
    </card>
  </xsl:template>

  <xsl:template match='/deck'>
    <deck>
      <author>
        <xsl:value-of select='@author' />
      </author>
      <description>
        <xsl:value-of select='@comment' />
      </description>
      <sound_path />
      <xsl:apply-templates />
    </deck>
  </xsl:template>

</xsl:stylesheet>
