/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OPlist;

class OP_conditional
extends OP_function {
    OPlist trueList;
    OPlist falseList;

    OP_conditional() {
    }

    boolean canInterpret() {
        return false;
    }

    void compile(ExpressionImage ei) {
        ei.asm_branch_start_true();
        this.trueList.compile(ei);
        ei.asm_branch_start_false();
        this.falseList.compile(ei);
        ei.asm_branch_end();
    }

    void interpret(OPlist list) throws Throwable {
    }

    public boolean optimize(OPlist list) throws Throwable {
        boolean optimized;
        if (this.prev instanceof OP_load) {
            boolean val = (Boolean)((OP_load)this.prev).what;
            list.remove(this.prev);
            optimized = true;
            OPlist integratelist = val ? this.trueList : this.falseList;
            integratelist.optimize();
            OP iop = integratelist.getFirst();
            while (iop != null) {
                OP niop = iop.next;
                integratelist.remove(iop);
                list.addBefore(this, iop);
                iop = niop;
            }
            list.remove(this);
        } else {
            optimized = this.trueList.optimize();
            optimized = this.falseList.optimize() || optimized;
        }
        return optimized;
    }

    public void setFalseList(OPlist falseList) {
        this.falseList = falseList;
    }

    public void setTrueList(OPlist trueList) {
        this.trueList = trueList;
    }

    public void setType(Class type) {
        OP tll = this.trueList.getLast();
        if (tll instanceof OP_convert) {
            ((OP_convert)tll).setType(type);
        } else {
            this.trueList.addLast(new OP_convert(type));
        }
        OP fll = this.falseList.getLast();
        if (fll instanceof OP_convert) {
            ((OP_convert)fll).setType(type);
        } else {
            this.falseList.addLast(new OP_convert(type));
        }
    }

    public String toString() {
        return "[?" + this.trueList.toString() + ":" + this.falseList.toString() + "]";
    }
}

