/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Class[] staticLib;
    private Class[] dynamicLib;
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;

    public Library(Class[] staticLib, Class[] dynamicLib) {
        this.staticLib = staticLib;
        this.dynamicLib = dynamicLib;
        this.rehash();
    }

    private void rehash() {
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (this.staticLib != null) {
            this.rehash(this.staticLib, true);
        }
        if (this.dynamicLib != null) {
            this.rehash(this.dynamicLib, false);
        }
    }

    private void rehash(Class[] arr, boolean gather_stateless) {
        int i = 0;
        while (i < arr.length) {
            Integer dynID = new Integer(i);
            Method[] ma = arr[i].getMethods();
            int j = 0;
            while (j < ma.length) {
                if (Modifier.isStatic(ma[j].getModifiers())) {
                    if (gather_stateless && this.rehash(ma[j])) {
                        this.stateless.put(ma[j], Boolean.TRUE);
                    }
                } else if (!gather_stateless && this.rehash(ma[j])) {
                    this.dynIDs.put(ma[j], dynID);
                }
                ++j;
            }
            Field[] fa = arr[i].getFields();
            int j2 = 0;
            while (j2 < fa.length) {
                if (Modifier.isStatic(fa[j2].getModifiers())) {
                    if (gather_stateless && this.rehash(fa[j2])) {
                        this.stateless.put(fa[j2], Boolean.TRUE);
                    }
                } else if (!gather_stateless && this.rehash(fa[j2])) {
                    this.dynIDs.put(fa[j2], dynID);
                }
                ++j2;
            }
            ++i;
        }
    }

    private boolean rehash(Method m) {
        return this.rehash(m.getName(), ExpressionImage.getSignature(m), m);
    }

    private boolean rehash(Field f) {
        return this.rehash(f.getName(), "()" + ExpressionImage.getSignature(f.getType()), f);
    }

    private boolean rehash(String name, String signature, Object fm) {
        Hashtable signatures = (Hashtable)this.names.get(name);
        if (signatures == null) {
            Hashtable<String, Object> signatures_new = new Hashtable<String, Object>();
            signatures_new.put(signature, fm);
            this.names.put(name, signatures_new);
            return true;
        }
        Object conflicting_method = signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, fm);
            return true;
        }
        Debug.println("Conflict was detected during the library initialization. Conflicting \"" + name + signature + "\", conflicting :" + conflicting_method + " and " + fm + " .");
        return false;
    }

    public void markStateDependent(String name, Class[] params) throws NoSuchMethodException {
        Object m = this.getMethod(name, params);
        Object removed = this.stateless.remove(m);
        Debug.assert(removed != null, "State dependent methos \"" + m + "\"is made state dependend again.");
    }

    public boolean isStateless(Object o) {
        return this.stateless.containsKey(o);
    }

    Object getMethod(String name, Class[] params) throws NoSuchMethodException {
        Hashtable signatures = (Hashtable)this.names.get(name);
        if (signatures == null) {
            throw new NoSuchMethodException("The name \"" + name + "\" is not defined.");
        }
        Vector applicable_methods = new Vector();
        Enumeration e = signatures.elements();
        while (e.hasMoreElements()) {
            Object cm = e.nextElement();
            Class[] cp = this.getParameterTypes(cm);
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    int i = 0;
                    while (i < cp.length && applicable) {
                        applicable = ExpressionImage.canConvertByWidening(params[i], cp[i]);
                        ++i;
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.addElement(cm);
        }
        if (applicable_methods.size() == 0) {
            throw new NoSuchMethodException("Function \"" + name + "\" exists," + " but parameters " + this.describe(name, params) + " can not be accepted by it.");
        }
        if (applicable_methods.size() == 1) {
            return applicable_methods.firstElement();
        }
        Enumeration e2 = applicable_methods.elements();
        Object most_specific = e2.nextElement();
        Class[] most_specific_params = this.getParameterTypes(most_specific);
        while (e2.hasMoreElements()) {
            Object cm = e2.nextElement();
            Class[] cp = this.getParameterTypes(cm);
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            int i = 0;
            while (i < cp.length) {
                moreSpecific = moreSpecific && ExpressionImage.canConvertByWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && ExpressionImage.canConvertByWidening(most_specific_params[i], cp[i]);
                ++i;
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(name, most_specific_params) + "\" and \"" + this.describe(name, cp) + "\" on invocation \"" + this.describe(name, params) + "\" .");
        }
        return most_specific;
    }

    private Class[] getParameterTypes(Object o) {
        Class[] res = null;
        if (o instanceof Field) {
            res = new Class[]{};
        } else if (o instanceof Method) {
            res = ((Method)o).getParameterTypes();
        } else {
            Debug.println("Library may contain only fields or methods.");
        }
        return res;
    }

    private String describe(String name, Class[] params) {
        String res = "";
        StringBuffer invp = new StringBuffer();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
                ++k;
            }
        }
        invp.append(')');
        res = invp.toString();
        return res;
    }

    int getDynamicMethodClassID(Object fm) {
        Integer id = (Integer)this.dynIDs.get(fm);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Library.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        Class[] par1;
        Method mf;
        Class[] par;
        Library ll = null;
        Class<?> math = null;
        try {
            math = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        t.startTest("Creating the library of java.lang.Math");
        try {
            Library l;
            Class[] sl = new Class[]{math};
            ll = l = new Library(sl, null);
            t.testOK();
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(double)");
        try {
            par = new Class[]{Double.TYPE};
            mf = (Method)ll.getMethod("round", par);
            if (mf != null && mf.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(float)");
        try {
            par = new Class[]{Float.TYPE};
            mf = (Method)ll.getMethod("round", par);
            if (mf != null && mf.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = (Method)ll.getMethod("round", par);
            par1 = new Class[]{Float.TYPE};
            if (mf != null && mf.equals(math.getMethod("round", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = (Method)ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            par = new Class[]{Byte.TYPE};
            mf = (Method)ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            par = new Class[]{Character.TYPE};
            mf = (Method)ll.getMethod("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            par = new Class[]{Integer.TYPE, Float.TYPE};
            mf = (Method)ll.getMethod("min", par);
            par1 = new Class[]{Float.TYPE, Float.TYPE};
            if (mf != null && mf.equals(math.getMethod("min", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of access to the field PI");
        try {
            par = new Class[]{};
            Field f = (Field)ll.getMethod("PI", par);
            if (f != null && f.getName().equals("PI")) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Checking assignment of state dependence ");
        try {
            ll.markStateDependent("random", null);
            if (!ll.isStateless(ll.getMethod("random", null))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }
}

