/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.DoubleObject;
import gnu.jel.tests.IntegerObject;
import gnu.jel.tests.StringObject;
import gnu.jel.tests.VariableProvider;
import java.util.HashMap;

public class IntegralDowncastingTest
extends TestingUtils {
    Library lib;
    Object[] rtp;
    VariableProvider vp;
    Class[] staticLib;
    Class[] dynamicLib;
    HashMap<String, Class> allowedCasts;

    public IntegralDowncastingTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.dynamicLib = new Class[1];
        this.rtp = new Object[1];
        this.vp = new VariableProvider();
        this.staticLib = new Class[2];
        this.staticLib[0] = Class.forName("java.lang.Math");
        this.staticLib[1] = this.vp.getClass();
        this.vp.xvar = 5.0;
        this.vp.strVar = "strVar";
        this.rtp[0] = this.vp;
        this.dynamicLib[0] = this.vp.getClass();
        Class[] dotLib = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Double"), Class.forName("gnu.jel.reflect.Double"), IntegerObject.class, DoubleObject.class};
        this.vp.addProperty("p1", "p1value");
        this.vp.addProperty("p1.s1", "p1s1value");
        this.vp.addProperty("p1.s2", "p1s2value");
        this.vp.addProperty("p1.d1", VariableProvider.makeJELDoubleObject(1.0));
        this.vp.addProperty("p1.s2.ss1", "p1s2ss1value");
        this.vp.addProperty("p1.b1t", VariableProvider.makeJELBooleanObject(true));
        this.vp.addProperty("p1.b1f", VariableProvider.makeJELBooleanObject(false));
        this.allowedCasts = new HashMap();
        this.allowedCasts.put("String", String.class);
        this.allowedCasts.put("Object", Object.class);
        this.allowedCasts.put("Double", Double.class);
        this.lib = new Library(this.staticLib, this.dynamicLib, dotLib, this.vp, this.allowedCasts);
    }

    public void test1() throws Throwable {
        IntegralDowncastingTest.simExpression("(Double)((Object)valDoubleObj)", new Double(1.0), null, this.rtp, this.lib, null);
    }

    public void test2() throws Throwable {
        IntegralDowncastingTest.simExpression("((String)((Object)\"abc\")).length", new Integer(3), null, this.rtp, this.lib, null);
    }

    public void test3() throws Throwable {
        this.allowedCasts.put("a1.a2.Strin", String.class);
        this.allowedCasts.put("a2.a3.Objec", Object.class);
        this.allowedCasts.put("a3.a4.Doubl", Double.class);
        IntegralDowncastingTest.simExpression("(a3.a4.Doubl)((a2.a3.Objec)valDoubleObj)", new Double(1.0), null, this.rtp, this.lib, null);
        IntegralDowncastingTest.simExpression("((a1.a2.Strin)((a2.a3.Objec)\"abc\")).length", new Integer(3), null, this.rtp, this.lib, null);
    }

    public void test4() throws Throwable {
        for (int i = 0; i < 8; ++i) {
            Class[] newDynamicLib = new Class[this.dynamicLib.length + 1];
            Object[] newRTP = new Object[this.rtp.length + 1];
            System.arraycopy(this.dynamicLib, 0, newDynamicLib, 0, this.dynamicLib.length);
            System.arraycopy(this.rtp, 0, newRTP, 0, this.rtp.length);
            switch (i) {
                case 0: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELBooleanObject(false);
                    break;
                }
                case 1: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELByteObject((byte)55);
                    break;
                }
                case 2: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELCharacterObject(' ');
                    break;
                }
                case 3: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELShortObject((short)55);
                    break;
                }
                case 4: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELIntegerObject(55);
                    break;
                }
                case 5: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELLongObject(55L);
                    break;
                }
                case 6: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELFloatObject(55.0f);
                    break;
                }
                case 7: {
                    newRTP[newRTP.length - 1] = VariableProvider.makeJELDoubleObject(55.0);
                    break;
                }
            }
            newDynamicLib[newDynamicLib.length - 1] = newRTP[newRTP.length - 1].getClass();
            Library lib1 = new Library(this.staticLib, newDynamicLib, new Class[0], this.vp, null);
            IntegralDowncastingTest.simExpression("aMethod", new Integer(1), null, newRTP, lib1, null);
        }
    }

    public void test5() throws Throwable {
        String[] typeNames = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double"};
        for (int k = 0; k < 8; ++k) {
            String fname = "val" + typeNames[k] + "JELObj";
            Object res = null;
            try {
                res = VariableProvider.class.getField(fname).get(this.vp);
            }
            catch (Exception e) {
                System.out.println(e);
                System.exit(1);
            }
            IntegralDowncastingTest.simExpression(fname, res, null, this.rtp, this.lib, null);
        }
    }

    public void test6() throws Throwable {
        IntegralDowncastingTest.simExpression("valString", new StringObject("strObj"), null, this.rtp, this.lib, null);
    }

    public void test7() throws Throwable {
        IntegralDowncastingTest.simExpression("valString+\"_ttt\"", "strObj_ttt", null, this.rtp, this.lib, null);
    }

    public void test8() throws Throwable {
        IntegralDowncastingTest.simExpression("\"ttt_\"+valString+\"_ttt\"", "ttt_strObj_ttt", null, this.rtp, this.lib, null);
    }

    public void test9() throws Throwable {
        IntegralDowncastingTest.simExpression("append_ttt(\"strObj\")+\"_ttt\"", "strObj_ttt_ttt", null, this.rtp, this.lib, null);
    }

    public void test10() throws Throwable {
        IntegralDowncastingTest.simExpression("append_ttt(valString)+\"_ttt\"", "strObj_ttt_ttt", null, this.rtp, this.lib, null);
    }

    public void test11() throws Throwable {
        IntegralDowncastingTest.simExpression("methodOnInt(valInteger)", new Integer(1), null, this.rtp, this.lib, null);
    }

    public void test12() throws Throwable {
        IntegralDowncastingTest.simExpression("methodOnInt(valIntegerJELObj)", new Integer(2), null, this.rtp, this.lib, null);
    }
}

