/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Library {
    private HashMap<String, HashMap<String, Member>> names;
    private HashMap<Member, Integer> dynIDs;
    private HashMap<Member, Boolean> stateless;
    private HashMap<Class<?>, HashMap<String, HashMap<String, Member>>> dotClasses;
    private boolean noDotSecurity = false;
    public DVMap resolver;
    public HashMap<String, Class<?>> cnmap;

    public Library(Class<?>[] classArray, Class<?>[] classArray2, Class<?>[] classArray3, DVMap dVMap, HashMap<String, Class<?>> hashMap) {
        this.cnmap = hashMap;
        this.resolver = dVMap;
        if (classArray3 == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = classArray3.length == 0;
            this.dotClasses = new HashMap();
            Class[] classArray4 = new Class[1];
            for (int i = 0; i < classArray3.length; ++i) {
                this.rehash(classArray3[i]);
            }
        }
        this.names = new HashMap();
        this.dynIDs = new HashMap();
        this.stateless = new HashMap();
        if (classArray != null) {
            Library.rehash(classArray, this.names, null, this.stateless);
        }
        if (classArray2 != null) {
            Library.rehash(classArray2, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class<?> clazz) {
        HashMap<String, HashMap<String, Member>> hashMap = new HashMap<String, HashMap<String, Member>>();
        Class[] classArray = new Class[]{clazz};
        Library.rehash(classArray, hashMap, new HashMap<Member, Integer>(), null);
        this.dotClasses.put(clazz, hashMap);
    }

    private static void rehash(Class<?>[] classArray, HashMap<String, HashMap<String, Member>> hashMap, HashMap<Member, Integer> hashMap2, HashMap<Member, Boolean> hashMap3) {
        for (int i = 0; i < classArray.length; ++i) {
            Integer n = new Integer(i);
            Method[] methodArray = classArray[i].getMethods();
            Field[] fieldArray = classArray[i].getFields();
            int n2 = methodArray.length;
            int n3 = n2 + fieldArray.length;
            for (int j = 0; j < n3; ++j) {
                Member member = (Member)((Object)(j < n2 ? methodArray[j] : fieldArray[j - n2]));
                if ((member.getModifiers() & 8) > 0) {
                    if (hashMap3 == null || !Library.rehash(hashMap, member)) continue;
                    hashMap3.put(member, Boolean.TRUE);
                    continue;
                }
                if (hashMap2 == null || !Library.rehash(hashMap, member)) continue;
                hashMap2.put(member, n);
            }
        }
    }

    private static boolean rehash(HashMap<String, HashMap<String, Member>> hashMap, Member member) {
        HashMap<String, Member> hashMap2;
        String string = member.getName();
        String string2 = Library.getSignature(member);
        if (Library.isField(member)) {
            string2 = "()" + string2;
        }
        if ((hashMap2 = hashMap.get(string)) == null) {
            HashMap<String, Member> hashMap3 = new HashMap<String, Member>();
            hashMap3.put(string2, member);
            hashMap.put(string, hashMap3);
            return true;
        }
        Member member2 = hashMap2.get(string2);
        if (member2 == null) {
            hashMap2.put(string2, member);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class<?>[] classArray) throws CompilationException {
        Member member;
        try {
            member = this.getMember(null, string, classArray);
        }
        catch (CompilationException compilationException) {
            if (compilationException.col < 0) {
                compilationException.col = 0;
            }
            throw compilationException;
        }
        Boolean bl = this.stateless.remove(member);
    }

    public boolean isStateless(Member member) {
        return this.stateless.containsKey(member);
    }

    public Member getMember(Class<?> clazz, String string, Class<?>[] classArray) throws CompilationException {
        HashMap<String, Member> hashMap;
        HashMap<String, HashMap<String, Member>> hashMap2 = this.names;
        if (clazz != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(clazz)) {
                Object[] objectArray = new Object[]{clazz};
                throw new CompilationException(12, objectArray);
            }
            hashMap2 = this.dotClasses.get(clazz);
            if (hashMap2 == null) {
                this.rehash(clazz);
                hashMap2 = this.dotClasses.get(clazz);
            }
        }
        if ((hashMap = hashMap2.get(string)) == null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new CompilationException(clazz == null ? 5 : 6, objectArray);
        }
        List<Member> list = this.getApplicable(clazz, string, classArray, hashMap, -1);
        if (list.size() == 0) {
            List<Member> list2 = this.getApplicable(clazz, string, classArray, hashMap, classArray.length);
            if (list2.size() == 0) {
                Object[] objectArray = new Object[]{string, Library.describe(string, classArray), clazz};
                throw new CompilationException(clazz == null ? 7 : 8, objectArray);
            }
            return this.getMostSpecific(clazz, string, classArray, list2, classArray.length);
        }
        return this.getMostSpecific(clazz, string, classArray, list, -1);
    }

    protected List<Member> getApplicable(Class<?> clazz, String string, Class<?>[] classArray, HashMap<String, Member> hashMap, int n) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member : hashMap.values()) {
            Class<?>[] classArray2 = Library.getParameterTypes(member, n);
            boolean bl = false;
            if (classArray != null) {
                if (classArray2.length == classArray.length) {
                    bl = true;
                    for (int i = 0; i < classArray2.length && bl; ++i) {
                        bl = OP.isWidening(classArray[i], classArray2[i]);
                    }
                }
            } else {
                boolean bl2 = bl = classArray2.length == 0;
            }
            if (!bl) continue;
            arrayList.add(member);
        }
        return arrayList;
    }

    protected Member getMostSpecific(Class<?> clazz, String string, Class<?>[] classArray, List<Member> list, int n) throws CompilationException {
        Iterator<Member> iterator = list.iterator();
        Member member = iterator.next();
        Class<?>[] classArray2 = Library.getParameterTypes(member, n);
        while (iterator.hasNext()) {
            Member member2 = iterator.next();
            Class<?>[] classArray3 = Library.getParameterTypes(member2, n);
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < classArray3.length; ++i) {
                bl = bl && OP.isWidening(classArray3[i], classArray2[i]);
                bl2 = bl2 && OP.isWidening(classArray2[i], classArray3[i]);
            }
            if (bl && !bl2) {
                member = member2;
                classArray2 = classArray3;
            }
            if (bl ^ bl2) continue;
            Object[] objectArray = new Object[]{Library.describe(string, classArray2), Library.describe(string, classArray3), Library.describe(string, classArray), clazz};
            throw new CompilationException(clazz == null ? 9 : 10, objectArray);
        }
        return member;
    }

    protected static String describe(String string, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('(');
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(classArray[i].toString());
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public int getDynamicMethodClassID(Member member) {
        Integer n = this.dynIDs.get(member);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static Class<?> getType(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof LocalField) {
            return ((LocalField)member).getType();
        }
        return OP.specialTypes[9];
    }

    public static Class<?>[] getParameterTypes(Member member, int n) {
        Class<?>[] classArray = null;
        if (member instanceof Method) {
            classArray = ((Method)member).getParameterTypes();
        }
        if (member instanceof LocalMethod) {
            classArray = ((LocalMethod)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            classArray = ((Constructor)member).getParameterTypes();
        }
        if (classArray != null) {
            int n2;
            if (n < classArray.length || classArray.length == 0 || !classArray[classArray.length - 1].isArray()) {
                return classArray;
            }
            Class[] classArray2 = new Class[n];
            for (n2 = 0; n2 < classArray.length - 1; ++n2) {
                classArray2[n2] = classArray[n2];
            }
            for (n2 = classArray.length - 1; n2 < n; ++n2) {
                classArray2[n2] = classArray[classArray.length - 1].getComponentType();
            }
            return classArray2;
        }
        return new Class[0];
    }

    public static String getSignature(Member member) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Library.isField(member)) {
            Class<?>[] classArray = Library.getParameterTypes(member, -1);
            stringBuilder.append('(');
            for (int i = 0; i < classArray.length; ++i) {
                Library.appendSignature(stringBuilder, classArray[i]);
            }
            stringBuilder.append(')');
        }
        Library.appendSignature(stringBuilder, Library.getType(member));
        return stringBuilder.toString();
    }

    public static boolean isField(Member member) {
        return member instanceof Field || member instanceof LocalField && !(member instanceof LocalMethod);
    }

    public static String getSignature(Class<?> clazz) {
        return Library.appendSignature(new StringBuilder(), clazz).toString();
    }

    private static StringBuilder appendSignature(StringBuilder stringBuilder, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            int n = OP.typeID(clazz);
            stringBuilder.append(n > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(n));
        } else if (clazz.isArray()) {
            stringBuilder.append('[');
            Library.appendSignature(stringBuilder, clazz.getComponentType());
        } else {
            stringBuilder.append('L');
            Library.appendHistoricalForm(stringBuilder, clazz.getName());
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    public static String toHistoricalForm(String string) {
        return Library.appendHistoricalForm(new StringBuilder(), string).toString();
    }

    private static StringBuilder appendHistoricalForm(StringBuilder stringBuilder, String string) {
        int n = string.length();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                c = '/';
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }
}

