
(defun is-prime (x)
  (if (or (= x 0) (= x 1) (> 0 x))
      nil
    (let ((i 2)
          (len (floor (sqrt x)))
          (is-prime t)
          (done nil))
      (while (and (<= i len) (not done))
        (when (= (* (/ x i) i) x)
          (setq is-prime nil)
          (setq done t))
        (incf i))
      is-prime)
    ))

(defun print-primes (max)
  (let ((i 0))
    (while (< i max)
      (if (is-prime i)
          (insert (format "%s " i)))
      (incf i))))

(is-prime (insert (format "%s" (+ (* 1000 1000) 3)))
(print-primes 1000000);;2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97

;;; primes.el ends here
