
;;; bak.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: bak.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unix Backup
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun bak-dir ()
  (safe-expand-file-name "~/bak/"))

;;  (cond
;;   (os-type--linux-p     (expand-file-name "~/bak/"))
;;   (os-type--microsoft-p (expand-file-name "~/bak/"))
;;   (t                    (expand-file-name "/bak-unix/")))
;;  )

;;;
;;; (bak--get-bases (setq dirname "~/bak") (setq extension ".zip"))
;;;
(defun bak--get-bases (dirname extension)
  (let* ((list (directory-files dirname nil extension))
         (ptr  list))
    (assert (or (string-match "\\.tar\\.gz$" extension)
                (string-match "\\.tar$"      extension)
                (string-match "\\.zip$"      extension)
                (string-match "\\.pdf$"      extension)
                ))
    (while ptr
      (if (string-match (concat "\\(^.*\\)" bak--yyyymmdd bak--hhmmss (regexp-quote extension) "$") (car ptr))
        (setcar ptr (substring (car ptr) (match-beginning 1) (match-end 1)))
        (setcar ptr nil))
      (setq ptr (cdr ptr)))
    (setq list (delete-duplicates list :test 'string=))
    (setq list (delete nil list))
    list))

;; NOTE:               Y    Y    Y    Y    M    M    D    D
(setq bak--yyyymmdd "-[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]")

;; NOTE:             h    h    m    m    s    s
(setq bak--hhmmss "-[0-9][0-9][0-9][0-9][0-9][0-9]")

;;;
;;; (bak--test-yyyymmdd  (setq dir "~/bak/frog/") (setq extension ".tar"))
;;; (bak--test-yyyymmdd  (setq dir "~/bak/")      (setq extension ".tar"))
;;;
(defun bak-test-inner (dirname extension)
  "Used by bak.el function bak--copy-to-other-drive--internal--internal
and cull-same-dates.el function ??? and cull-size-quota ???"

  (if (not (file-exists-p dirname))
      (debug))

  (let* ((list (directory-files-no-subdirs dirname
                                           nil
                                           (concat bak--yyyymmdd
                                                   extension))))

    ;;(debug)

    (if list
        (error "Directory %s not found YYYYMMDD format file(s) %s" dirname list))))

;;;
;;; (bak--test-yyyymmdd "~/bak/frog/" ".tar")
;;;
(defun bak-test (dirname)
  (interactive "DEnter dir: ")
  ;;(bak--test-yyyymmdd dirname "\\.[^.]*$")
  (bak-test-inner dirname ".zip")
  (bak-test-inner dirname ".tar")
  (bak-test-inner dirname ".tar.gz")
  ;;(bak-test-inner "~/bak/frog/" "\\.tar$")
  )

(if os-type--microsoft-p
    (safe-require 'bak-windows))
(if os-type--linux-p
    (safe-require 'bak-unix))

(progn
  (safe-require 'cull-same-dates)
  (safe-require 'cull-size-quota)
  (safe-require 'duplicate-files)
  (safe-require 'datify)
  (safe-require 'demises)
  )

(provide 'bak)
;;; bak.el ends here
