/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import kawa.DomTermBackend;
import org.domterm.Backend;
import org.domterm.DomHttpServer;

public class DomTermServer
extends DomHttpServer {
    private static DomTermServer instance = null;
    Backend pendingBackend;

    public DomTermServer(int port) throws UnknownHostException, IOException {
        super(port, new String[0]);
    }

    protected Backend createBackend() {
        if (this.pendingBackend != null) {
            Backend b = this.pendingBackend;
            this.pendingBackend = null;
            return b;
        }
        return new DomTermBackend();
    }

    public static synchronized DomTermServer getInstance() throws IOException {
        if (instance == null) {
            try {
                instance = new DomTermServer(0);
                DomTermServer.instance.pendingBackend = new DomTermBackend();
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
            instance.start();
        }
        return instance;
    }

    public static int getInstancePort() throws IOException {
        return DomTermServer.getInstance().getPort();
    }

    public static String startDomTermConsole(String command) throws Throwable {
        int htport = 0;
        if (command.startsWith("serve=")) {
            String portArg = command.substring(6);
            try {
                htport = Integer.parseInt(portArg);
            }
            catch (NumberFormatException ex) {
                return "bad port specifier in -w" + command + " option";
            }
        }
        if ("google-chrome".equals(command) || "chrome".equals(command)) {
            command = "browser=" + DomHttpServer.chromeCommand() + " --app=%U";
        } else if ("browser=google-chrome".equals(command) || "browser=chrome".equals(command)) {
            command = "browser=" + DomHttpServer.chromeCommand() + " %U";
        }
        if ("firefox".equals(command) || "browser=firefox".equals(command)) {
            command = "browser=" + DomHttpServer.firefoxCommand() + " %U";
        }
        boolean exitOnClose = !command.startsWith("serve");
        int port = DomTermServer.getInstancePort();
        DomHttpServer.setExitOnClose((boolean)exitOnClose);
        String url = "http://localhost:" + port + "/domterm/#ajax";
        if (command.equals("browser")) {
            if (!Desktop.isDesktopSupported()) {
                return "using default desktop browser not supported";
            }
            Desktop.getDesktop().browse(new URI(url));
            return null;
        }
        if (command.startsWith("browser=")) {
            String cmd = command.substring(8);
            if (cmd.indexOf(37) < 0) {
                cmd = cmd + " %U";
            }
            cmd = cmd.replace("%U", url).replace("%W", Integer.toString(port));
            Runtime.getRuntime().exec(cmd);
            return null;
        }
        if (command.startsWith("serve")) {
            return null;
        }
        return "unrecognized -w subcommand '" + command + "'";
    }
}

