/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;

public class ExifReader
implements MetadataReader {
    private final byte[] _data;
    private boolean _isMotorollaByteOrder;
    private Metadata _metadata;
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifInteropDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$GpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$OlympusMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType1MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType2MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$SonyMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$KodakMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CanonMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CasioType2MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CasioType1MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$FujifilmMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$KyoceraMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$PanasonicMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$PentaxMakernoteDirectory;

    public ExifReader(JpegSegmentData jpegSegmentData) {
        this(jpegSegmentData.getSegment((byte)-31));
    }

    public ExifReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31));
    }

    public ExifReader(InputStream inputStream) throws JpegProcessingException {
        this(new JpegSegmentReader(inputStream).readSegment((byte)-31));
    }

    public ExifReader(byte[] byArray) {
        this._data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        ExifDirectory exifDirectory = (ExifDirectory)this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (this._data.length <= 14) {
            exifDirectory.addError("Exif data segment must contain at least 14 bytes");
            return this._metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            exifDirectory.addError("Exif data segment doesn't begin with 'Exif'");
            return this._metadata;
        }
        String string = new String(this._data, 6, 2);
        if (!this.setByteOrder(string)) {
            exifDirectory.addError("Unclear distinction between Motorola/Intel byte ordering: " + string);
            return this._metadata;
        }
        if (this.get16Bits(8) != 42) {
            exifDirectory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this._metadata;
        }
        int n = this.get32Bits(10) + 6;
        if (n >= this._data.length - 1) {
            exifDirectory.addError("First exif directory offset is beyond end of Exif data segment");
            n = 14;
        }
        HashMap hashMap = new HashMap();
        this.processDirectory(exifDirectory, hashMap, n, 6);
        this.storeThumbnailBytes(exifDirectory, 6);
        return this._metadata;
    }

    private void storeThumbnailBytes(ExifDirectory exifDirectory, int n) {
        if (!exifDirectory.containsTag(259)) {
            return;
        }
        if (!exifDirectory.containsTag(514) || !exifDirectory.containsTag(513)) {
            return;
        }
        try {
            int n2 = exifDirectory.getInt(513);
            int n3 = exifDirectory.getInt(514);
            byte[] byArray = new byte[n3];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this._data[n + n2 + i];
            }
            exifDirectory.setByteArray(61441, byArray);
        }
        catch (Throwable throwable) {
            exifDirectory.addError("Unable to extract thumbnail: " + throwable.getMessage());
        }
    }

    private boolean setByteOrder(String string) {
        if ("MM".equals(string)) {
            this._isMotorollaByteOrder = true;
        } else if ("II".equals(string)) {
            this._isMotorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(Directory directory, HashMap hashMap, int n, int n2) {
        int n3;
        int n4;
        if (hashMap.containsKey(new Integer(n))) {
            return;
        }
        hashMap.put(new Integer(n), "processed");
        if (n >= this._data.length || n < 0) {
            directory.addError("Ignored directory marked to start outside data segement");
            return;
        }
        if (!this.isDirectoryLengthValid(n, n2)) {
            directory.addError("Illegally sized directory");
            return;
        }
        int n5 = this.get16Bits(n);
        block6: for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.calculateTagOffset(n, n4);
            int n6 = this.get16Bits(n3);
            int n7 = this.get16Bits(n3 + 2);
            if (n7 < 1 || n7 > 12) {
                directory.addError("Invalid format code: " + n7);
                continue;
            }
            int n8 = this.get32Bits(n3 + 4);
            if (n8 < 0) {
                directory.addError("Negative component count in EXIF");
                continue;
            }
            int n9 = n8 * BYTES_PER_FORMAT[n7];
            int n10 = this.calculateTagValueOffset(n9, n3, n2);
            if (n10 < 0 || n10 > this._data.length) {
                directory.addError("Illegal pointer offset value in EXIF");
                continue;
            }
            if (n9 < 0 || n10 + n9 > this._data.length) {
                directory.addError("Illegal number of bytes: " + n9);
                continue;
            }
            int n11 = n2 + this.get32Bits(n10);
            switch (n6) {
                case 34665: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifDirectory") : class$com$drew$metadata$exif$ExifDirectory), hashMap, n11, n2);
                    continue block6;
                }
                case 40965: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifInteropDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifInteropDirectory") : class$com$drew$metadata$exif$ExifInteropDirectory), hashMap, n11, n2);
                    continue block6;
                }
                case 34853: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$GpsDirectory == null ? ExifReader.class$("com.drew.metadata.exif.GpsDirectory") : class$com$drew$metadata$exif$GpsDirectory), hashMap, n11, n2);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(n10, hashMap, n2);
                    continue block6;
                }
                default: {
                    this.processTag(directory, n6, n10, n8, n7);
                }
            }
        }
        n4 = this.calculateTagOffset(n, n5);
        n3 = this.get32Bits(n4);
        if (n3 != 0) {
            if ((n3 += n2) >= this._data.length) {
                return;
            }
            if (n3 < n) {
                return;
            }
            this.processDirectory(directory, hashMap, n3, n2);
        }
    }

    private void processMakerNote(int n, HashMap hashMap, int n2) {
        Directory directory = this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (directory == null) {
            return;
        }
        String string = directory.getString(271);
        String string2 = new String(this._data, n, 2);
        String string3 = new String(this._data, n, 3);
        String string4 = new String(this._data, n, 4);
        String string5 = new String(this._data, n, 5);
        String string6 = new String(this._data, n, 6);
        String string7 = new String(this._data, n, 7);
        String string8 = new String(this._data, n, 8);
        if ("OLYMP".equals(string5) || "EPSON".equals(string5) || "AGFA".equals(string4)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$OlympusMakernoteDirectory == null ? (class$com$drew$metadata$exif$OlympusMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.OlympusMakernoteDirectory")) : class$com$drew$metadata$exif$OlympusMakernoteDirectory), hashMap, n + 8, n2);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(string5)) {
                if (this._data[n + 6] == 1) {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType1MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType1MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType1MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType1MakernoteDirectory), hashMap, n + 8, n2);
                } else if (this._data[n + 6] == 2) {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType2MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType2MakernoteDirectory), hashMap, n + 18, n + 10);
                } else {
                    directory.addError("Unsupported makernote data ignored.");
                }
            } else {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType2MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType2MakernoteDirectory), hashMap, n, n2);
            }
        } else if ("SONY CAM".equals(string8) || "SONY DSC".equals(string8)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$SonyMakernoteDirectory == null ? (class$com$drew$metadata$exif$SonyMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.SonyMakernoteDirectory")) : class$com$drew$metadata$exif$SonyMakernoteDirectory), hashMap, n + 12, n2);
        } else if ("KDK".equals(string3)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$KodakMakernoteDirectory == null ? (class$com$drew$metadata$exif$KodakMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.KodakMakernoteDirectory")) : class$com$drew$metadata$exif$KodakMakernoteDirectory), hashMap, n + 20, n2);
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CanonMakernoteDirectory == null ? (class$com$drew$metadata$exif$CanonMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CanonMakernoteDirectory")) : class$com$drew$metadata$exif$CanonMakernoteDirectory), hashMap, n, n2);
        } else if (string != null && string.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(string6)) {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CasioType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$CasioType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CasioType2MakernoteDirectory")) : class$com$drew$metadata$exif$CasioType2MakernoteDirectory), hashMap, n + 6, n2);
            } else {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CasioType1MakernoteDirectory == null ? (class$com$drew$metadata$exif$CasioType1MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CasioType1MakernoteDirectory")) : class$com$drew$metadata$exif$CasioType1MakernoteDirectory), hashMap, n, n2);
            }
        } else if ("FUJIFILM".equals(string8) || "Fujifilm".equalsIgnoreCase(string)) {
            boolean bl = this._isMotorollaByteOrder;
            this._isMotorollaByteOrder = false;
            int n3 = n + this.get32Bits(n + 8);
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$FujifilmMakernoteDirectory == null ? (class$com$drew$metadata$exif$FujifilmMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.FujifilmMakernoteDirectory")) : class$com$drew$metadata$exif$FujifilmMakernoteDirectory), hashMap, n3, n2);
            this._isMotorollaByteOrder = bl;
        } else if (string != null && string.toUpperCase().startsWith("MINOLTA")) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$OlympusMakernoteDirectory == null ? (class$com$drew$metadata$exif$OlympusMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.OlympusMakernoteDirectory")) : class$com$drew$metadata$exif$OlympusMakernoteDirectory), hashMap, n, n2);
        } else if ("KC".equals(string2) || "MINOL".equals(string5) || "MLY".equals(string3) || "+M+M+M+M".equals(string8)) {
            directory.addError("Unsupported Konica/Minolta data ignored.");
        } else if ("KYOCERA".equals(string7)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$KyoceraMakernoteDirectory == null ? (class$com$drew$metadata$exif$KyoceraMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.KyoceraMakernoteDirectory")) : class$com$drew$metadata$exif$KyoceraMakernoteDirectory), hashMap, n + 22, n2);
        } else if ("Panasonic\u0000\u0000\u0000".equals(new String(this._data, n, 12))) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$PanasonicMakernoteDirectory == null ? (class$com$drew$metadata$exif$PanasonicMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.PanasonicMakernoteDirectory")) : class$com$drew$metadata$exif$PanasonicMakernoteDirectory), hashMap, n + 12, n2);
        } else if ("AOC\u0000".equals(string4)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CasioType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$CasioType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CasioType2MakernoteDirectory")) : class$com$drew$metadata$exif$CasioType2MakernoteDirectory), hashMap, n + 6, n);
        } else if (string != null && (string.toUpperCase().startsWith("PENTAX") || string.toUpperCase().startsWith("ASAHI"))) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$PentaxMakernoteDirectory == null ? (class$com$drew$metadata$exif$PentaxMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.PentaxMakernoteDirectory")) : class$com$drew$metadata$exif$PentaxMakernoteDirectory), hashMap, n, n);
        } else {
            directory.addError("Unsupported makernote data ignored.");
        }
    }

    private boolean isDirectoryLengthValid(int n, int n2) {
        int n3 = this.get16Bits(n);
        int n4 = 2 + 12 * n3 + 4;
        return n4 + n + n2 < this._data.length;
    }

    private void processTag(Directory directory, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 7: {
                byte[] byArray = new byte[n3];
                int n5 = n3 * BYTES_PER_FORMAT[n4];
                for (int i = 0; i < n5; ++i) {
                    byArray[i] = this._data[n2 + i];
                }
                directory.setByteArray(n, byArray);
                break;
            }
            case 2: {
                directory.setString(n, this.readString(n2, n3));
                break;
            }
            case 5: 
            case 10: {
                if (n3 == 1) {
                    Rational rational = new Rational(this.get32Bits(n2), this.get32Bits(n2 + 4));
                    directory.setRational(n, rational);
                    break;
                }
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(this.get32Bits(n2 + 8 * i), this.get32Bits(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 1: 
            case 6: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this._data[n2 + i];
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 11: 
            case 12: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this._data[n2 + i];
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: 
            case 8: {
                if (n3 == 1) {
                    int n6 = this.get16Bits(n2);
                    directory.setInt(n, n6);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.get16Bits(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n7 = this.get32Bits(n2);
                    directory.setInt(n, n7);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.get32Bits(n2 + i * 4);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("Unknown format code " + n4 + " for tag " + n);
            }
        }
    }

    private int calculateTagValueOffset(int n, int n2, int n3) {
        if (n > 4) {
            int n4 = this.get32Bits(n2 + 8);
            if (n4 + n > this._data.length) {
                return -1;
            }
            return n3 + n4;
        }
        return n2 + 8;
    }

    private String readString(int n, int n2) {
        int n3;
        for (n3 = 0; n + n3 < this._data.length && this._data[n + n3] != 0 && n3 < n2; ++n3) {
        }
        return new String(this._data, n, n3);
    }

    private int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private int get16Bits(int n) {
        if (n < 0 || n + 2 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[n] << 8 & 0xFF00 | this._data[n + 1] & 0xFF;
        }
        return this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    private int get32Bits(int n) {
        if (n < 0 || n + 4 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[n] << 24 & 0xFF000000 | this._data[n + 1] << 16 & 0xFF0000 | this._data[n + 2] << 8 & 0xFF00 | this._data[n + 3] & 0xFF;
        }
        return this._data[n + 3] << 24 & 0xFF000000 | this._data[n + 2] << 16 & 0xFF0000 | this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

