/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2001, 2002 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#include "mail.h"


static char *
source_readline(void *closure, int cont)
{
  FILE *fp = closure;
  size_t s = 0;
  char *buf = NULL;
  
  (void)cont; /*unused*/
  if (getline (&buf, &s, fp) >= 0)
    {
      int len = strlen (buf);
      if (buf[len-1] == '\n')
	buf[len-1] = '\0';
      return buf;
    }
  return NULL;
}
  
/*
 * so[urce] file
 */

int
mail_source (int argc, char **argv)
{
  FILE *fp;
  int save_term;
  
  if (argc != 2)
    {
      util_error (_("source requires an argument"));
      return 1;
    }
  
  fp = fopen (argv[1], "r");
  if (!fp)
    {
      if (errno != ENOENT)
	util_error(_("can't open `%s': %s"), argv[1], strerror(errno));
      return 1;
    }

  save_term = interactive;
  interactive = 0;
  mail_mainloop(source_readline, fp, 0);
  interactive = save_term;
  fclose (fp);
  return 0;
}
