/* byte_ops.h: -*- C -*-  DESCRIPTIVE TEXT. */

/*  Copyright (c) 1996 Universal Access Inc.
    Author: E. B. Gamble Jr. (ebg@ai.mit.edu) Wed Nov  6 16:37:48 1996.  */

/* Byte Operators
 *
 * Byte operators enumerate the fundamental, lowest-level commands in the
 * 'byte engine'.  An operator and its operands comprise a single
 * instruction.  The listing below is used in various ways to construct the
 * enumerated types for bc_byte_op_t (see code.h), bc_byte_op_len_t (see
 * code.h) and bc_byte_code_spec_t (see engine.c). 
 *
 * The fields below are:
 *
 *    OPERATOR           NAME                LENGTH */
BYTEOP (LABEL,		"label",		3)
BYTEOP (CALL,		"call",			3)
BYTEOP (RETURN,		"return",		1)

BYTEOP (JUMP,		"jump",			3)
BYTEOP (JUMP_IF_FALSE,	"jump-if-false",	3)
BYTEOP (JUMP_IF_TRUE,	"jump-if-true",		3)
BYTEOP (JUMP_IF_EQ,	"jump-if-eq",		3)

/*
  BYTEOP (JUMP_LONG,		"jump-long",			3)
  BYTEOP (JUMP_LONG_IF_FALSE,	"jump-long-if-false",		3)
  BYTEOP (JUMP_LONG_IF_TRUE,	"jump-long-if-true",		3)
  BYTEOP (JUMP_LONG_IF_EQ,	"jump-long-if-eq",		3)
*/

BYTEOP (POP,		"pop",			1)
BYTEOP (DUP,		"dup",			1)
BYTEOP (DATA,		"data",			2)
BYTEOP (FMT,		"fmt",			3)

/* For <PROG exp ...> */
BYTEOP (PROG,		"prog",			2)

  /* Variable */
BYTEOP (VSET,		"vset",			2)
BYTEOP (VGET,		"vget",			2)

  /* Function */
BYTEOP (FSET,		"fset",			2)
BYTEOP (FGET,		"fget",			2)

  /* Stack */
BYTEOP (SSET,		"sset",			2)
BYTEOP (SGET,		"sget",			2)


/*
 * Primitive Operators
 *
 * A Primitive Operator is a Byte Operator used for the implementation of a
 * function (a 'primitive' function).  Primitive operators map between the
 * Meta-HTML function and the byte operator used to implement the function
 * within the byte engine.  In order to use a byte operator a Meta-HTML
 * function call must be a call to one of the primitive operators and the
 * arguments in the call must be of a number appropriate for the primitive
 * operator.  The listing below, like that in byte_ops.h, is used to
 * construct various types including bc_prim_op_spec_t (see code.h,
 * expand.c and optimize.c). */
#if ! defined (PRIMOP)
#define PRIMOP( operator, name, length, min_args, max_args )	\
  BYTEOP (operator, name, length)
#define PRIMOP_DEFINED
#endif /* ! defined (PRIMOP) */

/*
 *
 * The field below are:
 *
 *     OPERATOR         NAME                LENGTH MIN MAX  */
PRIMOP (NOT,		"not",			1,  1,  1)

   /* Numbers */
PRIMOP (ADD,		"add",			1,  2,  2)
PRIMOP (SUB,		"sub",			1,  2,  2)
PRIMOP (MUL,		"mul",			1,  2,  2)
PRIMOP (DIV,		"div",			1,  2,  2)

PRIMOP (RANDOMIZE,	"randomize",		1,  1,  1)
PRIMOP (RANDOM, 	"random",		1,  1,  1)

  /* Strings */
PRIMOP (DOWNCASE,	"downcase",		1,  1,  1)
PRIMOP (UPCASE,		"upcase",		1,  1,  1)
PRIMOP (CAPITALIZE,	"capitalize",		1,  1,  1)

  /* Symbols / Varibles */
PRIMOP (GET_VAR,	"get-var",		1,  1,  1)
PRIMOP (SET_VAR,	"set-var",		1,  2,  2)

#if defined (PRIMOP_DEFINED)
#undef PRIMOP
#undef PRIMOP_DEFINED
#endif /* defined (PRIMOP_DEFINED) */

/*
 *
 * Primitive Operators do not appear as symbol/variable values; rather
 * they are 'optimizations' when expanding.  But, primops do have
 * functions and those functions need to be values and those functions
 * need to be produced.  Either by defprim or explicit 'C code' to
 * produce a function.
 *
 * <defprim add a b>
 *    <add a b>
 * </defprim>
 *
 * The above looks recursive but the call to <add a b> would be
 * 'inlined' as a byte-op for BC_ADD_OP.
 *
 */


