/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// otti.cpp: dfinit le point d'entre pour l'application console.
//
#include <vector>
#include <map>
#include "StdAfx.h"
#include "BoardTest.h"
#include "MapManagerTest.h"
#include "MottiRulesManagerTest.h"
#include "StringDrawerTest.h"
#include "GameManagerTest.h"

#include <iostream>
#ifdef WIN32
#include <windows.h>
#endif 
#include "MapManager.h"
#include "GameManager.h"
#include "StringDrawer.h"
#include "SerializerTest.h"
#include "MapGenerator.h"
#include "JSONParser.h"
#include "LoginService.h"
#include "SessionService.h"
#include "GamePersistanceService.h"
#include "GameDispatcher.h"
#include <sstream> 
int launchTest();

#ifdef WIN32
int _tmain(int argc, _TCHAR* argv[])
{
	return launchTest();
}
#else
int main(int argc, char *argv[])
{
	return launchTest();
}	
#endif
#ifdef WIN32
int CALLBACK WinMain( HINSTANCE hInstance,  HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow
){
	
	
	return launchTest();

}
#endif

void tryee(std::istringstream &str)
{
	json_parser::Parser parser(&str);

	try{
	  json_parser::Value *val = parser.jValue();
	  
	  // Pretty printing
	  std::string str = val->toJSON(0, false);
	  std::cout << str << std::endl;

	  delete val;
	} catch (json_parser::ParseError e) {
	  std::cerr << "Oops, the file you gave me does not contain JSON data:" << std::endl;
	  std::cerr << e.what() << std::endl;
	}
}

int launchTest(){

	std::istringstream  ss1("{\n  \"ID\": \"SGML\"}");
	std::istringstream ss2("{\n  \"ID\": \"SGML\",\"RET\":\"FF\"}");
	std::istringstream ss3("{\n  \"IDs\": [{\"ID\":\"SGML\"},{\"ID\":\"FF\"}]}");
	std::istringstream ss4("{\n  \"IDs\": [{\"ID\":10},{\"ID\":true},{\"ID\":null}]}");
	tryee(ss1);
	tryee(ss2);
	tryee(ss3);
	tryee(ss4);
	BoardTest bTest;
	int nbBug = 0;
	std::cout<<"tre"<<std::endl;
	LoginService::remove("{\"login\": \"toto\"}");
	std::cout<<"tre2"<<std::endl;
	LoginService::remove("{\"login\": \"tata\"}");
	std::cout<<"tr3"<<std::endl;
	LoginService::registration("{\"login\": \"toto\",\"username\": \"toto\",\"password\": \"ret\", \"rememberPhrase\": \"\", \"rememberResult\": \"\",\"email\": \"\"}");
	std::cout<<"tre4"<<std::endl;
	LoginService::registration("{\"login\": \"tata\",\"username\": \"tata\",\"password\": \"ret\", \"rememberPhrase\": \"\", \"rememberResult\": \"\",\"email\": \"\"}");
	std::cout<<LoginService::login("{\"login\": \"tata\",\"password\": \"ret\"}")<<std::endl;

	std::string sessionId=SessionService::create("toto");
	SessionService::refresh(sessionId);
	std::cout<<SessionService::validate(sessionId)<<std::endl;
	SessionService::unvalidate(sessionId);
	SessionService::create("tata");
	std::cout<<SessionService::validate(sessionId)<<std::endl;
	
	Board bBoard(10,10);
	Case cCase;
	cCase.setCityCenter(true);
	cCase.setCaseType(Case::SELECTED);
	Player player("JoueurTest");
	cCase.setPlayer(&player);
	bBoard.setCase(5,5,cCase);
	
	std::cout<<bBoard.generateJson();
	
	std::string id=GamePersistanceService::create("toto");
	std::cout<<id<<std::endl;
	GamePersistanceService::save(id,bBoard.generateJson());
	std::cout<<id<<std::endl;
	std::vector<std::string> rev=GamePersistanceService::loads("toto");
	std::cout<<rev.size()<<std::endl;
	std::cout<<rev[0]<<std::endl;
	std::vector<std::string> rev2=GamePersistanceService::loads();
	std::cout<<rev2.size()<<std::endl;
	/*
	regeneratePassword : {"login":"","newPassword":""}
/motti/login : {"login":"","password":""} ->create session :on error return {"rememberPhrase":""}
/motti/logout : remove session
--need to be logged to call this services
/motti/game : list all id games : [{"id":1},{"id":2}]
/motti/game/@self : list all player id games : [{"id":1},{"id":2}]
/motti/game/<id> : get one game with detail : {"usernameToPlay":"","players":[{"username":"","tiles":[{"status":"selected","isCity":true,"x":1,"y":2}]}]
/motti/game/<id>/play
	*/
	try{
	GameDispatcher::dispatch("",std::string("createUser"),std::string("{\"login\": \"toto\",\"username\": \"toto\",\"password\": \"ret\", \"rememberPhrase\": \"\", \"rememberResult\": \"\",\"email\": \"\"}"));
	}catch(...)
	{}
	GameDispatcher::dispatch("",std::string("regeneratePassword"),std::string("{\"login\": \"toto\",\"password\": \"ret\"}"));
	std::string session3="";
	try{
	  session3=GameDispatcher::dispatch("",std::string("login"),std::string("{\"login\": \"toto\",\"password\": \"ret\"}"));
	}catch(...)
	{}
	id=GameDispatcher::dispatch(session3,std::string("createGame"),std::string("{\"width\": \"10\",\"heigth\": \"10\",\"nbPlayer\": \"10\",\"nbComputer\": \"10\"}"));
	GameDispatcher::dispatch(session3,std::string("attachUserOnGame"),std::string("{\"id\": \"10\",\"username\": \"toto\"}"));
	std::string message=GameDispatcher::dispatch(session3,std::string("play"),std::string("{\"id\": \"toto\",\"strategy\": \"Guerilla\",\"coordinates\": [{\"X\":\"1\",\"Y\":\"2\"}, {\"X\":\"1\",\"Y\":\"3\"}]}"));
	GameDispatcher::dispatch(session3,std::string("listGames"),std::string(""));
	GameDispatcher::dispatch(session3,std::string("listMyGames"),std::string(""));
	std::string game=GameDispatcher::dispatch(session3,std::string("getGame"),std::string("{\"id\": \"toto\"}"));
	GameDispatcher::dispatch(session3,std::string("logout"),std::string("{\"login\": \"toto\"}"));
	//std::string gameId=GamePersistanceService::create("toto");
	
	/*bTest.testAll();
	MapManagerTest mAmpTest;
	nbBug +=mAmpTest.testAll();
	MottiRulesManagerTest mMottiRule;
	nbBug += mMottiRule.testAll();
	StringDrawerTest strdra;
	nbBug += strdra.testAll();
	GameManagerTest gamManTest;
	nbBug +=gamManTest.testAll();
	SerializerTest test;
	nbBug += test.testAll();
	*/
#ifdef WIN32
	Sleep(50);
#endif
	return 0;
}


