#line 559 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "cmdline.opt"
/* This file is part of GNU Pies. -*- c -*-
   Copyright (C) 2008-2021 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#line 229 "cmdline.opt"
#ifdef HAVE_CONFIG_H
#line 229
# include <config.h>
#line 229
#endif
#line 229
#ifdef HAVE_GETOPT_H
#line 229
# include <getopt.h>
#line 229
#endif
#line 229
#include <unistd.h>
#line 229
#include <stdlib.h>
#line 229
#include <grecs.h>
#line 229
#include <grecs/opt.h>
#line 229
#ifndef EX_USAGE
#line 229
# define EX_USAGE 64
#line 229
#endif
#line 229
/* Option codes */
#line 229
enum {
#line 229
	_OPTION_INIT=255,
#line 32 "cmdline.opt"
	OPTION_CONFIG_HELP,
#line 45 "cmdline.opt"
	OPTION_FORCE,
#line 51 "cmdline.opt"
	OPTION_FOREGROUND,
#line 58 "cmdline.opt"
	OPTION_NO_INIT,
#line 73 "cmdline.opt"
	OPTION_INSTANCE,
#line 79 "cmdline.opt"
	OPTION_RATE,
#line 91 "cmdline.opt"
	OPTION_STDERR,
#line 97 "cmdline.opt"
	OPTION_SYNTAX,
#line 108 "cmdline.opt"
	OPTION_SYSLOG,
#line 121 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 128 "cmdline.opt"
#endif
#line 132 "cmdline.opt"
	OPTION_PREPROCESSOR,
#line 139 "cmdline.opt"
	OPTION_NO_PREPROCESSOR,
#line 196 "cmdline.opt"
	OPTION_DUMP_DEPMAP,
#line 203 "cmdline.opt"
	OPTION_TRACE_DEPEND,
#line 210 "cmdline.opt"
	OPTION_TRACE_PREREQ,
#line 217 "cmdline.opt"
	OPTION_SOURCE_INFO,
#line 229 "cmdline.opt"
	OPTION_USAGE,
#line 229 "cmdline.opt"
	MAX_OPTION
#line 229
};
#line 229
#ifdef HAVE_GETOPT_LONG
#line 229
static struct option long_options[] = {
#line 26 "cmdline.opt"
	{ "config-file", required_argument, 0, 'c' },
#line 32 "cmdline.opt"
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 45 "cmdline.opt"
	{ "force", no_argument, 0, OPTION_FORCE },
#line 51 "cmdline.opt"
	{ "foreground", no_argument, 0, OPTION_FOREGROUND },
#line 58 "cmdline.opt"
	{ "no-init", no_argument, 0, OPTION_NO_INIT },
#line 64 "cmdline.opt"
	{ "inetd", no_argument, 0, 'i' },
#line 73 "cmdline.opt"
	{ "instance", required_argument, 0, OPTION_INSTANCE },
#line 79 "cmdline.opt"
	{ "rate", required_argument, 0, OPTION_RATE },
#line 91 "cmdline.opt"
	{ "stderr", no_argument, 0, OPTION_STDERR },
#line 97 "cmdline.opt"
	{ "syntax", required_argument, 0, OPTION_SYNTAX },
#line 108 "cmdline.opt"
	{ "syslog", no_argument, 0, OPTION_SYSLOG },
#line 114 "cmdline.opt"
	{ "lint", no_argument, 0, 't' },
#line 121 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 122 "cmdline.opt"
	{ "telinit", no_argument, 0, 'T' },
#line 128 "cmdline.opt"
#endif
#line 132 "cmdline.opt"
	{ "preprocessor", required_argument, 0, OPTION_PREPROCESSOR },
#line 139 "cmdline.opt"
	{ "no-preprocessor", no_argument, 0, OPTION_NO_PREPROCESSOR },
#line 145 "cmdline.opt"
	{ "include-directory", required_argument, 0, 'I' },
#line 151 "cmdline.opt"
	{ "define", required_argument, 0, 'D' },
#line 157 "cmdline.opt"
	{ "undefine", required_argument, 0, 'U' },
#line 165 "cmdline.opt"
	{ "reload", no_argument, 0, 'r' },
#line 173 "cmdline.opt"
	{ "restart-component", no_argument, 0, 'R' },
#line 180 "cmdline.opt"
	{ "status", no_argument, 0, 's' },
#line 187 "cmdline.opt"
	{ "stop", no_argument, 0, 'S' },
#line 196 "cmdline.opt"
	{ "dump-depmap", no_argument, 0, OPTION_DUMP_DEPMAP },
#line 203 "cmdline.opt"
	{ "trace-depend", no_argument, 0, OPTION_TRACE_DEPEND },
#line 210 "cmdline.opt"
	{ "trace-prereq", no_argument, 0, OPTION_TRACE_PREREQ },
#line 217 "cmdline.opt"
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 223 "cmdline.opt"
	{ "debug", required_argument, 0, 'x' },
#line 229 "cmdline.opt"
	{ "help", no_argument, 0, 'h' },
#line 229 "cmdline.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 229 "cmdline.opt"
	{ "version", no_argument, 0, 'V' },
#line 229 "cmdline.opt"
	{0, 0, 0, 0}
#line 229
};
#line 229
#endif
#line 229

#line 229
static struct grecs_opthelp opthelp[] = {
#line 24 "cmdline.opt"
	{ NULL, NULL, 0, N_("Operation Mode") },
#line 28 "cmdline.opt"
	{
#line 28
#ifdef HAVE_GETOPT_LONG
#line 28
	  "-c, --config-file",
#line 28
#else
#line 28
	  "-c",
#line 28
#endif
#line 28
				   N_("FILE"), 0, N_("use FILE instead of the default configuration") },
#line 34 "cmdline.opt"
	{
#line 34
#ifdef HAVE_GETOPT_LONG
#line 34
	  "--config-help",
#line 34
#else
#line 34
	  "",
#line 34
#endif
#line 34
				   NULL, 0, N_("show configuration file summary") },
#line 41 "cmdline.opt"
	{
#line 41
#ifdef HAVE_GETOPT_LONG
#line 41
	  "-E",
#line 41
#else
#line 41
	  "-E",
#line 41
#endif
#line 41
				   NULL, 0, N_("preprocess configuration file and exit") },
#line 47 "cmdline.opt"
	{
#line 47
#ifdef HAVE_GETOPT_LONG
#line 47
	  "--force",
#line 47
#else
#line 47
	  "",
#line 47
#endif
#line 47
				   NULL, 0, N_("force startup even if another instance may be running") },
#line 53 "cmdline.opt"
	{
#line 53
#ifdef HAVE_GETOPT_LONG
#line 53
	  "--foreground",
#line 53
#else
#line 53
	  "",
#line 53
#endif
#line 53
				   NULL, 0, N_("remain in foreground") },
#line 60 "cmdline.opt"
	{
#line 60
#ifdef HAVE_GETOPT_LONG
#line 60
	  "--no-init",
#line 60
#else
#line 60
	  "",
#line 60
#endif
#line 60
				   NULL, 0, N_("don't suppose SysV init mode if PID is 1") },
#line 66 "cmdline.opt"
	{
#line 66
#ifdef HAVE_GETOPT_LONG
#line 66
	  "-i, --inetd",
#line 66
#else
#line 66
	  "-i",
#line 66
#endif
#line 66
				   NULL, 0, N_("run in inetd mode") },
#line 75 "cmdline.opt"
	{
#line 75
#ifdef HAVE_GETOPT_LONG
#line 75
	  "--instance",
#line 75
#else
#line 75
	  "",
#line 75
#endif
#line 75
				   N_("NAME"), 0, N_("set instance name") },
#line 81 "cmdline.opt"
	{
#line 81
#ifdef HAVE_GETOPT_LONG
#line 81
	  "--rate",
#line 81
#else
#line 81
	  "",
#line 81
#endif
#line 81
				   N_("NUMBER"), 0, N_("set default maximum rate for inetd-style components") },
#line 93 "cmdline.opt"
	{
#line 93
#ifdef HAVE_GETOPT_LONG
#line 93
	  "--stderr",
#line 93
#else
#line 93
	  "",
#line 93
#endif
#line 93
				   NULL, 0, N_("log to stderr") },
#line 99 "cmdline.opt"
	{
#line 99
#ifdef HAVE_GETOPT_LONG
#line 99
	  "--syntax",
#line 99
#else
#line 99
	  "",
#line 99
#endif
#line 99
				   N_("{pies|meta1|inetd|inittab}"), 0, N_("expect configuration files in the given syntax") },
#line 110 "cmdline.opt"
	{
#line 110
#ifdef HAVE_GETOPT_LONG
#line 110
	  "--syslog",
#line 110
#else
#line 110
	  "",
#line 110
#endif
#line 110
				   NULL, 0, N_("log to syslog") },
#line 116 "cmdline.opt"
	{
#line 116
#ifdef HAVE_GETOPT_LONG
#line 116
	  "-t, --lint",
#line 116
#else
#line 116
	  "-t",
#line 116
#endif
#line 116
				   NULL, 0, N_("parse configuration file and exit") },
#line 121 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 124 "cmdline.opt"
	{
#line 124
#ifdef HAVE_GETOPT_LONG
#line 124
	  "-T, --telinit",
#line 124
#else
#line 124
	  "-T",
#line 124
#endif
#line 124
				   NULL, 0, N_("telinit command: run \"pies -T --help\" for help") },
#line 128 "cmdline.opt"
#endif
#line 130 "cmdline.opt"
	{ NULL, NULL, 0, N_("Preprocessor") },
#line 134 "cmdline.opt"
	{
#line 134
#ifdef HAVE_GETOPT_LONG
#line 134
	  "--preprocessor",
#line 134
#else
#line 134
	  "",
#line 134
#endif
#line 134
				   N_("COMMAND"), 0, N_("use COMMAND instead of the default preprocessor") },
#line 141 "cmdline.opt"
	{
#line 141
#ifdef HAVE_GETOPT_LONG
#line 141
	  "--no-preprocessor",
#line 141
#else
#line 141
	  "",
#line 141
#endif
#line 141
				   NULL, 0, N_("disable preprocessing") },
#line 147 "cmdline.opt"
	{
#line 147
#ifdef HAVE_GETOPT_LONG
#line 147
	  "-I, --include-directory",
#line 147
#else
#line 147
	  "-I",
#line 147
#endif
#line 147
				   N_("DIR"), 0, N_("add include directory") },
#line 153 "cmdline.opt"
	{
#line 153
#ifdef HAVE_GETOPT_LONG
#line 153
	  "-D, --define",
#line 153
#else
#line 153
	  "-D",
#line 153
#endif
#line 153
				   N_("NAME[=VALUE]"), 0, N_("define a preprocessor symbol NAME as having VALUE or empty") },
#line 159 "cmdline.opt"
	{
#line 159
#ifdef HAVE_GETOPT_LONG
#line 159
	  "-U, --undefine",
#line 159
#else
#line 159
	  "-U",
#line 159
#endif
#line 159
				   N_("NAME"), 0, N_("undefine a preprocessor symbol NAME") },
#line 163 "cmdline.opt"
	{ NULL, NULL, 0, N_("Component Management") },
#line 168 "cmdline.opt"
	{
#line 168
#ifdef HAVE_GETOPT_LONG
#line 168
	  "-r, --reload",
#line 168
#else
#line 168
	  "-r",
#line 168
#endif
#line 168
				   NULL, 0, N_("reload the running instance of pies") },
#line 175 "cmdline.opt"
	{
#line 175
#ifdef HAVE_GETOPT_LONG
#line 175
	  "-R, --restart-component",
#line 175
#else
#line 175
	  "-R",
#line 175
#endif
#line 175
				   NULL, 0, N_("restart components named in the command line") },
#line 182 "cmdline.opt"
	{
#line 182
#ifdef HAVE_GETOPT_LONG
#line 182
	  "-s, --status",
#line 182
#else
#line 182
	  "-s",
#line 182
#endif
#line 182
				   NULL, 0, N_("display info about the running instance") },
#line 189 "cmdline.opt"
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-S, --stop",
#line 189
#else
#line 189
	  "-S",
#line 189
#endif
#line 189
				   NULL, 0, N_("stop the running instance") },
#line 194 "cmdline.opt"
	{ NULL, NULL, 0, N_("Debugging and Additional Diagnostics") },
#line 198 "cmdline.opt"
	{
#line 198
#ifdef HAVE_GETOPT_LONG
#line 198
	  "--dump-depmap",
#line 198
#else
#line 198
	  "",
#line 198
#endif
#line 198
				   NULL, 0, N_("dump dependency map") },
#line 205 "cmdline.opt"
	{
#line 205
#ifdef HAVE_GETOPT_LONG
#line 205
	  "--trace-depend",
#line 205
#else
#line 205
	  "",
#line 205
#endif
#line 205
				   NULL, 0, N_("trace dependencies") },
#line 212 "cmdline.opt"
	{
#line 212
#ifdef HAVE_GETOPT_LONG
#line 212
	  "--trace-prereq",
#line 212
#else
#line 212
	  "",
#line 212
#endif
#line 212
				   NULL, 0, N_("trace prerequisites") },
#line 219 "cmdline.opt"
	{
#line 219
#ifdef HAVE_GETOPT_LONG
#line 219
	  "--source-info",
#line 219
#else
#line 219
	  "",
#line 219
#endif
#line 219
				   NULL, 0, N_("show source info with debugging messages") },
#line 225 "cmdline.opt"
	{
#line 225
#ifdef HAVE_GETOPT_LONG
#line 225
	  "-x, --debug",
#line 225
#else
#line 225
	  "-x",
#line 225
#endif
#line 225
				   N_("LEVEL"), 0, N_("set debug verbosity level") },
#line 229 "cmdline.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 229 "cmdline.opt"
	{
#line 229
#ifdef HAVE_GETOPT_LONG
#line 229
	  "-h, --help",
#line 229
#else
#line 229
	  "-h",
#line 229
#endif
#line 229
				   NULL, 0, N_("Give this help list") },
#line 229 "cmdline.opt"
	{
#line 229
#ifdef HAVE_GETOPT_LONG
#line 229
	  "--usage",
#line 229
#else
#line 229
	  "",
#line 229
#endif
#line 229
				   NULL, 0, N_("Give a short usage message") },
#line 229 "cmdline.opt"
	{
#line 229
#ifdef HAVE_GETOPT_LONG
#line 229
	  "-V, --version",
#line 229
#else
#line 229
	  "-V",
#line 229
#endif
#line 229
				   NULL, 0, N_("Print program version") },
#line 229 "cmdline.opt"
};
#line 17 "cmdline.opt"

#line 17

#line 17
#ifndef PACKAGE_URL
#line 17
# define PACKAGE_URL NULL
#line 17
#endif
#line 17
static struct grecs_proginfo proginfo = {
#line 17
	"pies", /* progname */
#line 17
	NULL, /* subcommands */
#line 17
	N_("process invocation and execution supervisor"), /* docstring */
#line 17
	"", /* args_doc */
#line 17
	opthelp, /* opthelp */
#line 17
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 17
	NULL, /* print_help_hook */
#line 17
	NULL, /* print_version_hook */
#line 17
	PACKAGE_NAME,    /* package */
#line 17
	PACKAGE_VERSION, /* version */
#line 17
	NULL, /* license */
#line 17
	"2008-2020",/* copyright_year */
#line 17
	"Sergey Poznyakoff", /* copyright_holder */
#line 17
	NULL, /* *authors */
#line 17
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 17
	PACKAGE_URL, /* url */
#line 17
	NULL  /* epilogue */
#line 17
};
#line 17

#line 121 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 128 "cmdline.opt"
#endif
#line 229 "cmdline.opt"

#line 229


static void
pies_help_hook (FILE *fp)
{
  if (DEFAULT_PREPROCESSOR)
    {
      char *p;

      fprintf (fp, _("This pies preprocesses its configuration using %s\n"),
               DEFAULT_PREPROCESSOR);
      fprintf (fp, _("Preprocessor include path: %s\n"),
               DEFAULT_INCLUDE_PATH);
      if ((p = grecs_find_include_file ("pp-setup", 0)) != NULL)
        {
          fprintf (fp, "Preprocessor setup file: %s\n", p);
        }
      else
        {
          fprintf (fp, _("No preprocessor setup file found in include path.\n"));
        }
    }
  else
    fprintf (fp, _("This pies does not use configuration preprocessor.\n"));
  fputc ('\n', fp);
}

void
parse_options (int *pargc, char ***pargv)
{
  int argc = *pargc;
  char **argv = *pargv;
  int index;

  proginfo.print_help_hook = pies_help_hook;
  if (SYSVINIT_ACTIVE)
    {
      sysvinit_parse_argv (argc, argv);
      index = argc;
    }
  else
    {
      
#line 271
 {
#line 271
  int c;
#line 271

#line 271
  optind = 0;
#line 271
#ifdef HAVE_GETOPT_LONG
#line 271
  while ((c = getopt_long(argc, argv, "c:EitTI:D:U:rRsSx:hV",
#line 271
			  long_options, NULL)) != EOF)
#line 271
#else
#line 271
  while ((c = getopt(argc, argv, "c:EitTI:D:U:rRsSx:hV")) != EOF)
#line 271
#endif
#line 271
    {
#line 271
      switch (c)
#line 271
	{
#line 271
	default:
#line 271
	   	   exit(EX_USAGE);
#line 271
	#line 28 "cmdline.opt"
	 case 'c':
#line 28
	  {
#line 28

  config_file_add (current_syntax, optarg);

#line 30
	     break;
#line 30
	  }
#line 34 "cmdline.opt"
	 case OPTION_CONFIG_HELP:
#line 34
	  {
#line 34

  config_help ();
  exit (0);

#line 37
	     break;
#line 37
	  }
#line 41 "cmdline.opt"
	 case 'E':
#line 41
	  {
#line 41

  preprocess_only = 1;

#line 43
	     break;
#line 43
	  }
#line 47 "cmdline.opt"
	 case OPTION_FORCE:
#line 47
	  {
#line 47

  force_option = 1;

#line 49
	     break;
#line 49
	  }
#line 53 "cmdline.opt"
	 case OPTION_FOREGROUND:
#line 53
	  {
#line 53

  log_to_stderr_only = 1;
  foreground = 1;

#line 56
	     break;
#line 56
	  }
#line 60 "cmdline.opt"
	 case OPTION_NO_INIT:
#line 60
	  {
#line 60

  /* handled separately */

#line 62
	     break;
#line 62
	  }
#line 66 "cmdline.opt"
	 case 'i':
#line 66
	  {
#line 66

  if (!instance)
    instance = "inetd";
  current_syntax = &config_syntax_tab[CONF_INETD];
  inetd_mode = 1;

#line 71
	     break;
#line 71
	  }
#line 75 "cmdline.opt"
	 case OPTION_INSTANCE:
#line 75
	  {
#line 75

  instance = optarg;

#line 77
	     break;
#line 77
	  }
#line 81 "cmdline.opt"
	 case OPTION_RATE:
#line 81
	  {
#line 81

  char *p;
  default_max_rate = strtoul (optarg, &p, 10);
  if (*p)
    {
      logmsg (LOG_ERR, _("not a number: %s"), optarg);
      exit (EX_USAGE);
    }

#line 89
	     break;
#line 89
	  }
#line 93 "cmdline.opt"
	 case OPTION_STDERR:
#line 93
	  {
#line 93

  log_to_stderr_only = 1;

#line 95
	     break;
#line 95
	  }
#line 99 "cmdline.opt"
	 case OPTION_SYNTAX:
#line 99
	  {
#line 99

  current_syntax = str_to_config_syntax (optarg);
  if (!current_syntax)
    {
      logmsg (LOG_ERR, _("unknown syntax type: %s"), optarg);
      exit (EX_USAGE);
    }

#line 106
	     break;
#line 106
	  }
#line 110 "cmdline.opt"
	 case OPTION_SYSLOG:
#line 110
	  {
#line 110

  log_to_stderr_only = 0;

#line 112
	     break;
#line 112
	  }
#line 116 "cmdline.opt"
	 case 't':
#line 116
	  {
#line 116

  log_to_stderr_only = 1;
  lint_mode = 1;

#line 119
	     break;
#line 119
	  }
#line 121 "cmdline.opt"
#if PIES_SYSVINIT_ENABLED
#line 124 "cmdline.opt"
	 case 'T':
#line 124
	  {
#line 124

  log_to_stderr_only = 1;
  exit (telinit (argc - (optind - 1), argv + (optind - 1)));

#line 127
	     break;
#line 127
	  }
#line 128 "cmdline.opt"
#endif
#line 134 "cmdline.opt"
	 case OPTION_PREPROCESSOR:
#line 134
	  {
#line 134

    if (DEFAULT_PREPROCESSOR)
        grecs_preprocessor = optarg;

#line 137
	     break;
#line 137
	  }
#line 141 "cmdline.opt"
	 case OPTION_NO_PREPROCESSOR:
#line 141
	  {
#line 141

    grecs_preprocessor = NULL;

#line 143
	     break;
#line 143
	  }
#line 147 "cmdline.opt"
	 case 'I':
#line 147
	  {
#line 147

  grecs_preproc_add_include_dir(optarg);

#line 149
	     break;
#line 149
	  }
#line 153 "cmdline.opt"
	 case 'D':
#line 153
	  {
#line 153

  pp_add_option ("-D", optarg);

#line 155
	     break;
#line 155
	  }
#line 159 "cmdline.opt"
	 case 'U':
#line 159
	  {
#line 159

  pp_add_option ("-U", optarg);

#line 161
	     break;
#line 161
	  }
#line 168 "cmdline.opt"
	 case 'r':
#line 168
	  {
#line 168

  log_to_stderr_only = 1;
  command = COM_RELOAD;

#line 171
	     break;
#line 171
	  }
#line 175 "cmdline.opt"
	 case 'R':
#line 175
	  {
#line 175

  log_to_stderr_only = 1;
  command = COM_RESTART_COMPONENT;

#line 178
	     break;
#line 178
	  }
#line 182 "cmdline.opt"
	 case 's':
#line 182
	  {
#line 182

  log_to_stderr_only = 1;
  command = COM_STATUS;

#line 185
	     break;
#line 185
	  }
#line 189 "cmdline.opt"
	 case 'S':
#line 189
	  {
#line 189

  log_to_stderr_only = 1;
  command = COM_STOP;

#line 192
	     break;
#line 192
	  }
#line 198 "cmdline.opt"
	 case OPTION_DUMP_DEPMAP:
#line 198
	  {
#line 198

  log_to_stderr_only = 1;
  command = COM_DUMP_DEPMAP;

#line 201
	     break;
#line 201
	  }
#line 205 "cmdline.opt"
	 case OPTION_TRACE_DEPEND:
#line 205
	  {
#line 205

  log_to_stderr_only = 1;
  command = COM_TRACE_DEPEND;  

#line 208
	     break;
#line 208
	  }
#line 212 "cmdline.opt"
	 case OPTION_TRACE_PREREQ:
#line 212
	  {
#line 212

  log_to_stderr_only = 1;
  command = COM_TRACE_PREREQ;  

#line 215
	     break;
#line 215
	  }
#line 219 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 219
	  {
#line 219

  source_info_option = 1;

#line 221
	     break;
#line 221
	  }
#line 225 "cmdline.opt"
	 case 'x':
#line 225
	  {
#line 225

  debug_level = strtoul (optarg, NULL, 0);

#line 227
	     break;
#line 227
	  }
#line 229 "cmdline.opt"
	 case 'h':
#line 229
	  {
#line 229

#line 229
		grecs_print_help(&proginfo);
#line 229
		exit(0);
#line 229
	 
#line 229
	     break;
#line 229
	  }
#line 229 "cmdline.opt"
	 case OPTION_USAGE:
#line 229
	  {
#line 229

#line 229
		grecs_print_usage(&proginfo);
#line 229
		exit(0);
#line 229
	 
#line 229
	     break;
#line 229
	  }
#line 229 "cmdline.opt"
	 case 'V':
#line 229
	  {
#line 229

#line 229
	        /* Give version */
#line 229
		grecs_print_version(&proginfo, stdout);
#line 229
		exit(0);
#line 229
	 
#line 229
	     break;
#line 229
	  }

#line 271 "cmdline.opt"
	}
#line 271
    }
#line 271
  index = optind;
#line 271
 }
#line 271
;
    }
  *pargc -= index;
  *pargv += index;
}
