/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt --unamed-opts=CLIENT [SERVER] --no-handle-help --no-handle-error --no-handle-version --input ./shishi.ggo --file-name shishi_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "shishi_cmd.h"

const char *gengetopt_args_info_purpose = "Shishi command line client.  If no command is given, Shishi\nacquire or list a valid ticket for you, identified by CLIENT (if\nempty, default username in default realm), for the service SERVER (if\nempty, ticket granting ticket for client realm).";

const char *gengetopt_args_info_usage = "Usage: shishi [OPTION]... [CLIENT [SERVER]]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nCommands:",
  "  -d, --destroy                 Destroy tickets in local cache, limited by any\n                                  --client-name or --server-name.\n                                  (default=off)",
  "  -l, --list                    List tickets in local cache, limited by any\n                                  --client-name and --server-name.\n                                  (default=off)",
  "  -r, --renew                   Renew ticket.  Use --server-name to specify\n                                  ticket, default is the most recent renewable\n                                  ticket granting ticket for the default realm.\n                                  (default=off)",
  "\nFlags:",
  "      --forwardable             Get a forwardable ticket, i.e., one that can be\n                                  used to get forwarded tickets.  (default=off)",
  "      --forwarded               Get a forwarded ticket.  (default=off)",
  "      --proxiable               Get a proxiable ticket, i.e., one that can be\n                                  used to get proxy tickets.  (default=off)",
  "      --proxy                   Get a proxy ticket.  (default=off)",
  "      --renewable               Get a renewable ticket.  (default=off)",
  "\nOptions:",
  "      --client-name=NAME        Client name. Default is login username.",
  "  -E, --encryption-type=ETYPE,[ETYPE...]\n                                Encryption types to use.  ETYPE is either\n                                  registered name or integer.  Valid values\n                                  include 'aes128', 'aes256', 'aes' (same as\n                                  'aes256'), '3des', 'des-md5', 'des-md4',\n                                  'des-crc', 'des' (same as 'des-md5'), and\n                                  'arcfour'.",
  "  -e, --endtime=STRING          Specify when ticket validity should expire.\n                                  The time syntax may be relative (to the start\n                                  time), such as '20 hours', or absolute, such\n                                  as '2001-02-03 04:05:06 CET'. The default is\n                                  8 hours after the start time.",
  "      --realm=STRING            Set default realm.",
  "      --renew-till=STRING       Specify renewable life of ticket.  Implies\n                                  --renewable.  Accepts same time syntax as\n                                  --endtime.  If --renewable is specified, the\n                                  default is 1 week after the start time.",
  "      --server-name=NAME        Server name. Default is 'krbtgt/REALM' where\n                                  REALM is client realm.",
  "  -s, --starttime=STRING        Specify when ticket should start to be valid.\n                                  Accepts same time syntax as --endtime. The\n                                  default is to become valid immediately.",
  "      --ticket-granter=NAME     Service name in ticket to use for\n                                  authenticating request. Only for TGS.\n                                  Defaults to 'krbtgt/REALM@REALM' where REALM\n                                  is client realm.",
  "\nOther options:",
  "      --configuration-file=FILE Read user configuration from FILE.",
  "  -c, --ticket-file=FILE        Read tickets from FILE.",
  "  -o, --library-options=STRING  Parse STRING as a configuration file statement.",
  "  -q, --quiet                   Don't produce any diagnostic output.\n                                    (default=off)",
  "      --system-configuration-file=FILE\n                                Read system configuration from FILE.",
  "      --ticket-write-file=FILE  Write tickets from FILE.  Default is to write\n                                  them back to where they were read from.",
  "  -v, --verbose                 Produce verbose output.\n                                  Use multiple times to increase amount of\n                                  information.",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->destroy_given = 0 ;
  args_info->list_given = 0 ;
  args_info->renew_given = 0 ;
  args_info->forwardable_given = 0 ;
  args_info->forwarded_given = 0 ;
  args_info->proxiable_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->renewable_given = 0 ;
  args_info->client_name_given = 0 ;
  args_info->encryption_type_given = 0 ;
  args_info->endtime_given = 0 ;
  args_info->realm_given = 0 ;
  args_info->renew_till_given = 0 ;
  args_info->server_name_given = 0 ;
  args_info->starttime_given = 0 ;
  args_info->ticket_granter_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->ticket_file_given = 0 ;
  args_info->library_options_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->system_configuration_file_given = 0 ;
  args_info->ticket_write_file_given = 0 ;
  args_info->verbose_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->destroy_flag = 0;
  args_info->list_flag = 0;
  args_info->renew_flag = 0;
  args_info->forwardable_flag = 0;
  args_info->forwarded_flag = 0;
  args_info->proxiable_flag = 0;
  args_info->proxy_flag = 0;
  args_info->renewable_flag = 0;
  args_info->client_name_arg = NULL;
  args_info->client_name_orig = NULL;
  args_info->encryption_type_arg = NULL;
  args_info->encryption_type_orig = NULL;
  args_info->endtime_arg = NULL;
  args_info->endtime_orig = NULL;
  args_info->realm_arg = NULL;
  args_info->realm_orig = NULL;
  args_info->renew_till_arg = NULL;
  args_info->renew_till_orig = NULL;
  args_info->server_name_arg = NULL;
  args_info->server_name_orig = NULL;
  args_info->starttime_arg = NULL;
  args_info->starttime_orig = NULL;
  args_info->ticket_granter_arg = NULL;
  args_info->ticket_granter_orig = NULL;
  args_info->configuration_file_arg = NULL;
  args_info->configuration_file_orig = NULL;
  args_info->ticket_file_arg = NULL;
  args_info->ticket_file_orig = NULL;
  args_info->library_options_arg = NULL;
  args_info->library_options_orig = NULL;
  args_info->quiet_flag = 0;
  args_info->system_configuration_file_arg = NULL;
  args_info->system_configuration_file_orig = NULL;
  args_info->ticket_write_file_arg = NULL;
  args_info->ticket_write_file_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->destroy_help = gengetopt_args_info_help[3] ;
  args_info->list_help = gengetopt_args_info_help[4] ;
  args_info->renew_help = gengetopt_args_info_help[5] ;
  args_info->forwardable_help = gengetopt_args_info_help[7] ;
  args_info->forwarded_help = gengetopt_args_info_help[8] ;
  args_info->proxiable_help = gengetopt_args_info_help[9] ;
  args_info->proxy_help = gengetopt_args_info_help[10] ;
  args_info->renewable_help = gengetopt_args_info_help[11] ;
  args_info->client_name_help = gengetopt_args_info_help[13] ;
  args_info->encryption_type_help = gengetopt_args_info_help[14] ;
  args_info->endtime_help = gengetopt_args_info_help[15] ;
  args_info->realm_help = gengetopt_args_info_help[16] ;
  args_info->renew_till_help = gengetopt_args_info_help[17] ;
  args_info->server_name_help = gengetopt_args_info_help[18] ;
  args_info->starttime_help = gengetopt_args_info_help[19] ;
  args_info->ticket_granter_help = gengetopt_args_info_help[20] ;
  args_info->configuration_file_help = gengetopt_args_info_help[22] ;
  args_info->ticket_file_help = gengetopt_args_info_help[23] ;
  args_info->library_options_help = gengetopt_args_info_help[24] ;
  args_info->quiet_help = gengetopt_args_info_help[25] ;
  args_info->system_configuration_file_help = gengetopt_args_info_help[26] ;
  args_info->ticket_write_file_help = gengetopt_args_info_help[27] ;
  args_info->verbose_help = gengetopt_args_info_help[28] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->client_name_arg));
  free_string_field (&(args_info->client_name_orig));
  free_string_field (&(args_info->encryption_type_arg));
  free_string_field (&(args_info->encryption_type_orig));
  free_string_field (&(args_info->endtime_arg));
  free_string_field (&(args_info->endtime_orig));
  free_string_field (&(args_info->realm_arg));
  free_string_field (&(args_info->realm_orig));
  free_string_field (&(args_info->renew_till_arg));
  free_string_field (&(args_info->renew_till_orig));
  free_string_field (&(args_info->server_name_arg));
  free_string_field (&(args_info->server_name_orig));
  free_string_field (&(args_info->starttime_arg));
  free_string_field (&(args_info->starttime_orig));
  free_string_field (&(args_info->ticket_granter_arg));
  free_string_field (&(args_info->ticket_granter_orig));
  free_string_field (&(args_info->configuration_file_arg));
  free_string_field (&(args_info->configuration_file_orig));
  free_string_field (&(args_info->ticket_file_arg));
  free_string_field (&(args_info->ticket_file_orig));
  free_string_field (&(args_info->library_options_arg));
  free_string_field (&(args_info->library_options_orig));
  free_string_field (&(args_info->system_configuration_file_arg));
  free_string_field (&(args_info->system_configuration_file_orig));
  free_string_field (&(args_info->ticket_write_file_arg));
  free_string_field (&(args_info->ticket_write_file_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->destroy_given)
    write_into_file(outfile, "destroy", 0, 0 );
  if (args_info->list_given)
    write_into_file(outfile, "list", 0, 0 );
  if (args_info->renew_given)
    write_into_file(outfile, "renew", 0, 0 );
  if (args_info->forwardable_given)
    write_into_file(outfile, "forwardable", 0, 0 );
  if (args_info->forwarded_given)
    write_into_file(outfile, "forwarded", 0, 0 );
  if (args_info->proxiable_given)
    write_into_file(outfile, "proxiable", 0, 0 );
  if (args_info->proxy_given)
    write_into_file(outfile, "proxy", 0, 0 );
  if (args_info->renewable_given)
    write_into_file(outfile, "renewable", 0, 0 );
  if (args_info->client_name_given)
    write_into_file(outfile, "client-name", args_info->client_name_orig, 0);
  if (args_info->encryption_type_given)
    write_into_file(outfile, "encryption-type", args_info->encryption_type_orig, 0);
  if (args_info->endtime_given)
    write_into_file(outfile, "endtime", args_info->endtime_orig, 0);
  if (args_info->realm_given)
    write_into_file(outfile, "realm", args_info->realm_orig, 0);
  if (args_info->renew_till_given)
    write_into_file(outfile, "renew-till", args_info->renew_till_orig, 0);
  if (args_info->server_name_given)
    write_into_file(outfile, "server-name", args_info->server_name_orig, 0);
  if (args_info->starttime_given)
    write_into_file(outfile, "starttime", args_info->starttime_orig, 0);
  if (args_info->ticket_granter_given)
    write_into_file(outfile, "ticket-granter", args_info->ticket_granter_orig, 0);
  if (args_info->configuration_file_given)
    write_into_file(outfile, "configuration-file", args_info->configuration_file_orig, 0);
  if (args_info->ticket_file_given)
    write_into_file(outfile, "ticket-file", args_info->ticket_file_orig, 0);
  if (args_info->library_options_given)
    write_into_file(outfile, "library-options", args_info->library_options_orig, 0);
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->system_configuration_file_given)
    write_into_file(outfile, "system-configuration-file", args_info->system_configuration_file_orig, 0);
  if (args_info->ticket_write_file_given)
    write_into_file(outfile, "ticket-write-file", args_info->ticket_write_file_orig, 0);
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

	FIX_UNUSED(stop_char);
	
  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "destroy",	0, NULL, 'd' },
        { "list",	0, NULL, 'l' },
        { "renew",	0, NULL, 'r' },
        { "forwardable",	0, NULL, 0 },
        { "forwarded",	0, NULL, 0 },
        { "proxiable",	0, NULL, 0 },
        { "proxy",	0, NULL, 0 },
        { "renewable",	0, NULL, 0 },
        { "client-name",	1, NULL, 0 },
        { "encryption-type",	1, NULL, 'E' },
        { "endtime",	1, NULL, 'e' },
        { "realm",	1, NULL, 0 },
        { "renew-till",	1, NULL, 0 },
        { "server-name",	1, NULL, 0 },
        { "starttime",	1, NULL, 's' },
        { "ticket-granter",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 0 },
        { "ticket-file",	1, NULL, 'c' },
        { "library-options",	1, NULL, 'o' },
        { "quiet",	0, NULL, 'q' },
        { "system-configuration-file",	1, NULL, 0 },
        { "ticket-write-file",	1, NULL, 0 },
        { "verbose",	0, NULL, 'v' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVdlrE:e:s:c:o:qv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'd':	/* Destroy tickets in local cache, limited by any --client-name or --server-name..  */
        
        
          if (update_arg((void *)&(args_info->destroy_flag), 0, &(args_info->destroy_given),
              &(local_args_info.destroy_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "destroy", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* List tickets in local cache, limited by any --client-name and --server-name..  */
        
        
          if (update_arg((void *)&(args_info->list_flag), 0, &(args_info->list_given),
              &(local_args_info.list_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "list", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Renew ticket.  Use --server-name to specify ticket, default is the most recent renewable ticket granting ticket for the default realm..  */
        
        
          if (update_arg((void *)&(args_info->renew_flag), 0, &(args_info->renew_given),
              &(local_args_info.renew_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "renew", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'E':	/* Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
        
        
          if (update_arg( (void *)&(args_info->encryption_type_arg), 
               &(args_info->encryption_type_orig), &(args_info->encryption_type_given),
              &(local_args_info.encryption_type_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "encryption-type", 'E',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time..  */
        
        
          if (update_arg( (void *)&(args_info->endtime_arg), 
               &(args_info->endtime_orig), &(args_info->endtime_given),
              &(local_args_info.endtime_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "endtime", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately..  */
        
        
          if (update_arg( (void *)&(args_info->starttime_arg), 
               &(args_info->starttime_orig), &(args_info->starttime_given),
              &(local_args_info.starttime_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "starttime", 's',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Read tickets from FILE..  */
        
        
          if (update_arg( (void *)&(args_info->ticket_file_arg), 
               &(args_info->ticket_file_orig), &(args_info->ticket_file_given),
              &(local_args_info.ticket_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "ticket-file", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Parse STRING as a configuration file statement..  */
        
        
          if (update_arg( (void *)&(args_info->library_options_arg), 
               &(args_info->library_options_orig), &(args_info->library_options_given),
              &(local_args_info.library_options_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "library-options", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Don't produce any diagnostic output.
.  */
        
        
          if (update_arg((void *)&(args_info->quiet_flag), 0, &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Produce verbose output.
        Use multiple times to increase amount of information..  */
        
          local_args_info.verbose_given++;
        
          break;

        case 0:	/* Long option with no short option */
          /* Get a forwardable ticket, i.e., one that can be used to get forwarded tickets..  */
          if (strcmp (long_options[option_index].name, "forwardable") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->forwardable_flag), 0, &(args_info->forwardable_given),
                &(local_args_info.forwardable_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "forwardable", '-',
                additional_error))
              goto failure;
          
          }
          /* Get a forwarded ticket..  */
          else if (strcmp (long_options[option_index].name, "forwarded") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->forwarded_flag), 0, &(args_info->forwarded_given),
                &(local_args_info.forwarded_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "forwarded", '-',
                additional_error))
              goto failure;
          
          }
          /* Get a proxiable ticket, i.e., one that can be used to get proxy tickets..  */
          else if (strcmp (long_options[option_index].name, "proxiable") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->proxiable_flag), 0, &(args_info->proxiable_given),
                &(local_args_info.proxiable_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "proxiable", '-',
                additional_error))
              goto failure;
          
          }
          /* Get a proxy ticket..  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->proxy_flag), 0, &(args_info->proxy_given),
                &(local_args_info.proxy_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "proxy", '-',
                additional_error))
              goto failure;
          
          }
          /* Get a renewable ticket..  */
          else if (strcmp (long_options[option_index].name, "renewable") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->renewable_flag), 0, &(args_info->renewable_given),
                &(local_args_info.renewable_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "renewable", '-',
                additional_error))
              goto failure;
          
          }
          /* Client name. Default is login username..  */
          else if (strcmp (long_options[option_index].name, "client-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->client_name_arg), 
                 &(args_info->client_name_orig), &(args_info->client_name_given),
                &(local_args_info.client_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "client-name", '-',
                additional_error))
              goto failure;
          
          }
          /* Set default realm..  */
          else if (strcmp (long_options[option_index].name, "realm") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->realm_arg), 
                 &(args_info->realm_orig), &(args_info->realm_given),
                &(local_args_info.realm_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "realm", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time..  */
          else if (strcmp (long_options[option_index].name, "renew-till") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->renew_till_arg), 
                 &(args_info->renew_till_orig), &(args_info->renew_till_given),
                &(local_args_info.renew_till_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "renew-till", '-',
                additional_error))
              goto failure;
          
          }
          /* Server name. Default is 'krbtgt/REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "server-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->server_name_arg), 
                 &(args_info->server_name_orig), &(args_info->server_name_given),
                &(local_args_info.server_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "server-name", '-',
                additional_error))
              goto failure;
          
          }
          /* Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "ticket-granter") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ticket_granter_arg), 
                 &(args_info->ticket_granter_orig), &(args_info->ticket_granter_given),
                &(local_args_info.ticket_granter_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ticket-granter", '-',
                additional_error))
              goto failure;
          
          }
          /* Read user configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "configuration-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->configuration_file_arg), 
                 &(args_info->configuration_file_orig), &(args_info->configuration_file_given),
                &(local_args_info.configuration_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "configuration-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Read system configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "system-configuration-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->system_configuration_file_arg), 
                 &(args_info->system_configuration_file_orig), &(args_info->system_configuration_file_given),
                &(local_args_info.system_configuration_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "system-configuration-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Write tickets from FILE.  Default is to write them back to where they were read from..  */
          else if (strcmp (long_options[option_index].name, "ticket-write-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ticket_write_file_arg), 
                 &(args_info->ticket_write_file_orig), &(args_info->ticket_write_file_given),
                &(local_args_info.ticket_write_file_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ticket-write-file", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
