//****************************************************************************//
//      Pretranslator class:
//
//              Base class for text processing before HTML generation
//              Forwards calls to appropriate TextGenerator
//
//      Don Stauffer       Revision: June 2003
//****************************************************************************//
#ifndef	srcPretranslator_H
#define	srcPretranslator_H

#include	<string>

using std::string;

struct Pretranslator
{
  public:


  virtual ~ Pretranslator (void)
    {
    }


    virtual void generate (const string & s);

    virtual void generate (const string & s, int start, int end);

    virtual void generateln (const string & s);

    virtual void generate_preproc (const string & s);

    virtual void generate_normal (const string & s);

    virtual void generateTab (void);

    virtual void startComment (const string & s);

    virtual void endComment (const string & s);

    virtual void generateComment (const string & s);

    virtual void startString (const string & s);

    virtual void endString (const string & s);

    virtual void generateString (const string & s);

    virtual void generateKeyWord (const string & s);

    virtual void generateBaseType (const string & s);

    virtual void generatePreProc (const string & s);

    virtual void generateNumber (const string & s);

    virtual void generateSymbol (const string & s);

    virtual void generateFunction (const string & s);

    virtual void generateCBracket (const string & s);

    virtual void generate( const std::string &elem, const std::string &s );
    virtual void generate( const std::string &elem, const std::string &s, int start, int end );
    virtual void generate_preproc(const std::string &elem, const std::string &s);

    virtual void generateln( const std::string &elem, const std::string &s );

    virtual void generateEntire( const std::string &elem, const std::string &s );

    virtual void beginText( const std::string &elem, const std::string &s );
    virtual void endText( const std::string &elem, const std::string &s );

};				//      class           Pretranslator

#endif //      #ifndef srcPretranslator_H
