/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_do_withdraw.h
 * @brief implementation of the do_withdraw function for Postgres
 * @author Özgür Kesim
 */
#ifndef PG_DO_WITHDRAW_H
#define PG_DO_WITHDRAW_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"
/**
 * Perform reserve update as part of an age-withdraw operation, checking for
 * sufficient balance and fulfillment of age requirements. Finally persisting
 * the withdrawal details.
 *
 * @param cls the `struct PostgresClosure` with the plugin-specific state
 * @param withdraw the withdraw data
 * @param now the timestamp of the withdraw
 * @param[out] balance_ok set to true if the balance was sufficient
 * @param[out] reserve_balance set to original balance of the reserve
 * @param[out] age_ok set to true if age requirements were met
 * @param[out] allowed_maximum_age if @e age_ok is FALSE, this is set to the allowed maximum age
 * @param[out] reserve_birthday if @e age_ok is FALSE, this is set to the reserve's birthday
 * @param[out] idempotent set to true if an entry already exists for the given h_planchets and reserve_pub
 * @param[out] noreveal_index if @e idempotent is true, set to the noreveal_index in the existing record
 * @param[out] nonce_reuse set to true if the blinding_seed has been found in the table for a different withdraw
 * @return 0 if no reserve was found, 1 if a reserve was found, else the query execution status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_do_withdraw (
  void *cls,
  const struct TALER_EXCHANGEDB_Withdraw *withdraw,
  const struct GNUNET_TIME_Timestamp *now,
  bool *balance_ok,
  struct TALER_Amount *reserve_balance,
  bool *age_ok,
  uint16_t *allowed_maximum_age,
  uint32_t *reserve_birthday,
  bool *idempotent,
  uint16_t *noreveal_index,
  bool *nonce_reuse);

#endif
