/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_enable_rules.c
 * @brief Implementation of the enable_rules function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include "taler_error_codes.h"
#include "taler_dbevents.h"
#include "taler_pq_lib.h"
#include "pg_enable_rules.h"
#include "pg_helper.h"


enum GNUNET_GenericReturnValue
TEH_PG_enable_rules (
  void *cls,
  const char *schema)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_Context *conn;
  enum GNUNET_GenericReturnValue ret;
  char *sp;

  GNUNET_asprintf (&sp,
                   "SET search_path TO %s,exchange;",
                   schema);
  {
    struct GNUNET_PQ_ExecuteStatement es[] = {
      GNUNET_PQ_make_try_execute (sp),
      GNUNET_PQ_EXECUTE_STATEMENT_END
    };
    char *schemadash;

    GNUNET_asprintf (&schemadash,
                     "%s-",
                     schema);
    conn = GNUNET_PQ_connect_with_cfg (pg->cfg,
                                       "exchangedb-postgres",
                                       schemadash,
                                       es,
                                       NULL);
    GNUNET_free (schemadash);
  }
  GNUNET_free (sp);
  if (NULL == conn)
    return GNUNET_SYSERR;
  {
    char *procfile;

    GNUNET_asprintf (&procfile,
                     "%s-procedures",
                     schema);
    ret = GNUNET_PQ_exec_sql (conn,
                              procfile);
    /* $SCHEMA-procedures MAY not exist, so only check for hard error */
    GNUNET_break (GNUNET_SYSERR != ret);
    if (GNUNET_NO == ret)
      ret = GNUNET_OK;
    GNUNET_free (procfile);
  }
  GNUNET_PQ_disconnect (conn);
  return ret;
}
