/*
  This file is part of TALER
  Copyright (C) 2020 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file yna.c
 * @brief Utility functions for yes/no/all filters
 * @author Jonathan Buchanan
 */
#include "platform.h"
#include "taler_util.h"


/**
 * Convert YNA value to a string.
 *
 * @param yna value to convert
 * @return string representation ("yes"/"no"/"all").
 */
const char *
TALER_yna_to_string (enum TALER_EXCHANGE_YesNoAll yna)
{
  switch (yna)
  {
  case TALER_EXCHANGE_YNA_YES:
    return "yes";
  case TALER_EXCHANGE_YNA_NO:
    return "no";
  case TALER_EXCHANGE_YNA_ALL:
    return "all";
  }
  GNUNET_assert (0);
}
