/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_delete_donau_instance.c
 * @brief Implementation of the delete_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_delete_donau_instance.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
TMH_PG_delete_donau_instance (
  void *cls,
  const char *id,
  const uint64_t donau_serial_id)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&donau_serial_id),
    GNUNET_PQ_query_param_string (id),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (pg,
           "delete_donau_instance",
           "DELETE FROM merchant_donau_instances di"
           " USING merchant_instances mi"
           " WHERE di.merchant_instance_serial = mi.merchant_serial"
           "   AND di.donau_instances_serial = $1"
           "   AND mi.merchant_id = $2;");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "delete_donau_instance",
                                             params);
}