// Simple plugin to trim extensions from the filename of relative import statements.
// Required to get linaria to work with `moduleResulution: "Node16"` imports.
// @author Florian Dold
module.exports = function({ types: t }) {
  return {
    name: "trim-extension",
    visitor: {
      ImportDeclaration: (x) => {
        const src = x.node.source;
        if (src.value.startsWith(".")) {
          if (src.value.endsWith(".js")) {
            const newVal = src.value.replace(/[.]js$/, "")
            x.node.source = t.stringLiteral(newVal);
          }
        }
        if (src.value.endsWith(".jsx")) {
          const newVal = src.value.replace(/[.]jsx$/, "")
          x.node.source = t.stringLiteral(newVal);
        }
      },
    }
  };
}
