/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { TranslatedString } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { DefaultForm as TestedComponent } from "../forms-ui.js";
import { FormDesign, UIHandlerId } from "../forms-types.js";

export default {
  title: "Input Toggle",
};

export namespace Simplest {
  export interface Form {
    comment: string;
  }
}

type TargetObject = {
  accept: boolean;
};
const initial: TargetObject = {
  accept: true,
};

export const SimpleUsage = tests.createExample(TestedComponent, {
  initial,
  design: {
    type: "single-column",
    fields: [
      {
        type: "toggle",
        label: "do you accept?" as TranslatedString,
        id: "accept",
      },
    ],
  },
});

export const WithThreeState = tests.createExample(TestedComponent, {
  initial,
  design: {
    type: "single-column",
    fields: [
      {
        type: "toggle",
        label: "do you accept?" as TranslatedString,
        threeState: true,
        required: true,
        id: "accept",
      },
    ],
  },
});

export const StartUndefinedOnlyTwoStates = tests.createExample(
  TestedComponent,
  {
    initial: {},
    design: {
      type: "single-column",
      fields: [
        {
          type: "toggle",
          label: "do you accept?" as TranslatedString,
          required: true,
          id: "accept",
        },
      ],
    },
  },
);

export const UseTrueValue = tests.createExample(
  TestedComponent,
  {
    initial: {},
    design: {
      type: "single-column",
      fields: [
        {
          type: "toggle",
          label: "do you accept?" as TranslatedString,
          required: true,
          id: "accept",
          trueValue: "YES",
          onlyTrueValue: true,
        },
      ],
    },
  },
);
