/* reallocarray function that is glibc compatible.

   Copyright (C) 2017-2024 Free Software Foundation, Inc.

   This file is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   This file is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* written by Darshit Shah */

#include <config.h>

#include <stdckdint.h>
#include <stdlib.h>
#include <errno.h>

void *
reallocarray (void *ptr, size_t nmemb, size_t size)
{
  size_t nbytes;
  if (ckd_mul (&nbytes, nmemb, size))
    {
      errno = ENOMEM;
      return NULL;
    }

  /* Work around realloc glitch by treating a 0 size as if it were 1,
     to avoid undefined behavior in strict C23 platforms,
     and so that returning NULL is equivalent to failing.  */
  if (nbytes == 0)
    nbytes = 1;

  /* Call realloc, setting errno to ENOMEM on failure.  */
  return realloc (ptr, nbytes);
}
