/* print out the set in a easily parsed format
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/
/* ======================================================================== */
/*       Feb. 10 1997   Isaac Tsai                                          */
/* ======================================================================== */

#ifdef NeXT
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>  
#include <bsd/curses.h>
#else
#include <curses.h>
#include <malloc.h>
double atof();
#endif

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>  
#include <signal.h>
#include <time.h>
#include <math.h>
#include <string.h>


#define   YES    1

#include "pProj/capaCommon.h"

char    *progname;


void
print_answer(FILE *o_fp,int ans_cnt,char *ans,char *lower,char *upper,char *unit)
{
  if (unit && (strlen(unit)>0)) 
    if(ans_cnt==2)  fprintf(o_fp,"ANS:%s %s %s %s\n",ans,lower,upper,unit); 
    else  fprintf(o_fp,"ANS:%s %s\n",lower,unit);
  else 
    if(ans_cnt==2)  fprintf(o_fp,"ANS:%s %s %s\n",ans,lower,upper); 
    else  fprintf(o_fp,"ANS:%s\n",lower);
}

void print_question (FILE *o_fp,char *question)
{
  fprintf(o_fp,"BQES:\n%s\nEQES:\n",question);
}

int main (int argc, char  **argv) 
{
  extern  int        Parsemode_f;
  extern  int        managermode;

  Problem_t  *first_prob,*p;
  int         q_cnt, num_answers, result, setIdx = 1, q_idx;
  char        lower[ANSWER_STRING_LENG], upper[ANSWER_STRING_LENG];
  int         StartSet = 1, EndSet = 1;
  char        tmp_str[ANSWER_STRING_LENG];
  double      tmp_ans;
  T_student   a_student;

  Parsemode_f=ASCII_MODE;
  if ( argc > 6 || argc < 5 ) {
    printf("USAGE: %s StudentNumber StudentName ?managermode? startSet [endSet]\n",
	   argv[0]);
    printf("CAPA is licensed under the GNU GPL v2, see COPYING for details.\n");
    exit(-1);
  }
  strncpy(a_student.s_sn,argv[1],MAX_STUDENT_NUMBER);
  a_student.s_sn[MAX_STUDENT_NUMBER]='\0';
  strncpy(a_student.s_nm,argv[2],MAX_NAME_CHAR);
  a_student.s_nm[MAX_NAME_CHAR]='\0';
  managermode=atoi(argv[3]);
  
  StartSet=atoi(argv[4]);
  if ( argc == 6 ) {
    EndSet=atoi(argv[5]);
  } else {
    EndSet=StartSet;
  }
  for(setIdx=StartSet; setIdx <= EndSet; setIdx++) {
    printf("SET:%d\n",setIdx);
    result = capa_parse_student(setIdx, &first_prob, &a_student,&q_cnt,NULL);
    printf("\n");
    if ( result > 0 ) { 
      p = first_prob;
      for( q_idx = 0; q_idx < q_cnt; q_idx++ ) {
	print_question(stdout,p->question);
	if( p->ans_type == ANSWER_IS_SUBJECTIVE) {
	  printf("ANS: Subjective Answers\n");
	} else {
	  if( p->ans_type == ANSWER_IS_FLOAT ) {
	    tmp_ans = (double)atof(p->answer);
	    sprintf(tmp_str, p->ans_fmt, tmp_ans);
	  } else {
	    strcpy(tmp_str,p->answer);
	  }

	  num_answers = calc_ansrange(p->ans_type, p->calc, p->answer, p->ans_fmt,
				      p->tol_type, p->tolerance, lower, upper);
	  print_answer(stdout,num_answers,tmp_str,lower,upper,p->unit_str);
	}
	p = p->next;
      }
    } else {
      printf("ERROR:for %s set %d\n",a_student.s_sn,setIdx);
    }
    free_problems(first_prob);
    if( setIdx < EndSet ) { 
      printf("\n"); 
    }
  }
  printf("\nDONE:%s\n",a_student.s_sn);
  return (0);
}


