/* general functionality for all parts of GUI CAPA
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * common.funct.c
 * Created Guy Albertelli II 1998
 */
#include <stdio.h>
#include <tk.h>
#include <pProj/capaCommon.h>
#include <common.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>

/* Used by the parse front end to escape any special characters in TCL */
/* arguments are source buffer, destination buffer, and where to start */
/* in the destination buffer                                           */
int capaPrepareBuffer(char *buf,char *buf2,int j)
{
  int i;
  for(i=0;i<strlen(buf);i++,j++)
    {
      switch(buf[i])
	{
	case '$':case '[': case ']': case '{': case '}': case '\\': case '"':
	  buf2[j]='\\';
	  j++;
	  buf2[j]=buf[i];
	  break;
	default:
	  buf2[j]=buf[i];
	  break;
	}
    }
  buf2[j]='\0';
  return j;
}

int bufInsert(Tcl_Interp*interp,char*window,char*string) 
{
  char *buf;
  char *buf2;
#ifdef _UPDATE
  char *update=";update";
#else
  char *update=" ";
#endif

  buf=capa_malloc(BUFFER_SIZE+strlen(string)*2,1);
  buf2=capa_malloc(BUFFER_SIZE+strlen(string)*3,1);
  capaPrepareBuffer(string,buf,0);
  sprintf(buf2,"%s insert end \"%s\" answer%s",window,buf,update);
  if (Tcl_Eval(interp,buf2) != TCL_OK) { fprintf(stderr,"problem with bufInsert\n"); }
  capa_mfree(buf);
  capa_mfree(buf2);
}

void print_begin_item(int mode,Tcl_Interp *interp,char *window,int q_idx)
{
  char buf[BUFFER_SIZE];
  switch(mode) {
    case TeX_MODE: bufInsert(interp,window, "\\item "); break;
    case ASCII_MODE:
          sprintf(buf, "%d) ", q_idx); 
	  bufInsert(interp,window,buf); break;
    case HTML_MODE: bufInsert(interp,window, "<LI> "); break;
  }
}

void capaInsertAnswer(Problem_t *p,Tcl_Interp *interp, char *window) {
  extern int Parsemode_f;
  char* answer;

  answer=answers_string(Parsemode_f,p);
  bufInsert(interp,window,answer);
  capa_mfree(answer);
}

/* updates the gDate var with the current date and reregisters itself
 * to run in .8 seconds
 */

int capaDateUpdate(ClientData clientdata, Tcl_Interp *interp, int argc, 
		   char *argv[])
{
  time_t rightNow=time(NULL);

  if (Tcl_SetVar(interp,"gDate",asctime(localtime(&rightNow)),
		 TCL_GLOBAL_ONLY) == NULL)
    {
      fprintf(stderr,"Tcl_Eval error\n");
      fprintf(stderr,"%s\n",interp->result);
      return TCL_ERROR;
    }

  if (Tcl_Eval(interp,"after 800 { dateUpdate } ") != TCL_OK)
    {
      fprintf(stderr,"Tcl_Eval error\n");
      fprintf(stderr,"%s\n",interp->result);
      return TCL_ERROR;
    }
  return TCL_OK;
}

int capaGetExistingSections(ClientData clientdata, Tcl_Interp *interp, 
			int argc, char *argv[])
{
  int i=0,result,sectionArray[MAX_SECTION_COUNT];
  char buf[BUFFER_SIZE];

  Tcl_ResetResult(interp);
  result=capa_get_section_count(sectionArray);
  if (result==-1)
    {
      Tcl_AppendElement(interp,"Unable to find a classl file.\n");
      return TCL_ERROR;
    }
  for(i=1;i<=sectionArray[0];i++) 
    {
      if ( sectionArray[i] !=0 ) 
	{
	  sprintf(buf,"%d %d",i, sectionArray[i]);
	  Tcl_AppendElement(interp,buf);
	}
    }
  return TCL_OK;
}

/* finds how many set.db files there are */
int howManySetDBFile()
{
  char     filename[BUFFER_SIZE], *pathName;
  int     ii;
  
  pathName=getcwd(NULL,BUFFER_SIZE);
  ii=1;
  sprintf(filename,"%s/records/set%d.db",pathName,ii);
  while(!access(filename, F_OK)) {
    ii++;
    sprintf(filename,"%s/records/set%d.db",pathName,ii);
  }
  free(pathName);
  return (ii-1);
}

/* argv[1] is student number argv[2] is setnumber */
int capaGetSpecifiCapaId(ClientData clientdata, Tcl_Interp *interp, int argc, 
			 char *argv[])
{
  char buf[MAX_BUFFER_SIZE];
  if (argc==3) {
    sprintf(buf,"%d",capa_PIN(argv[1],atoi(argv[2]),0));
    Tcl_AppendElement(interp,buf);
  } else {
    sprintf(buf,"Usage: %s StudentNumber SetNumber",argv[0]);
    Tcl_AppendElement(interp,buf);
  }
  return TCL_OK;
}

/* argv[1] is student number argv[2] is section number argv[3] is setnumber */
int capaIsSetOpen(ClientData clientdata, Tcl_Interp *interp, int argc, 
			 char *argv[])
{
  char buf[MAX_BUFFER_SIZE];
  if (argc==4) {
    sprintf(buf,"%d",capa_check_date(CHECK_OPEN_DATE,argv[1],atoi(argv[2]),atoi(argv[3])));
    Tcl_AppendElement(interp,buf);
  } else {
    sprintf(buf,"Usage: %s StudentNumber SectionNumber SetNumber",argv[0]);
    Tcl_AppendElement(interp,buf);
  }
  return TCL_OK;
}

void message()
{
  signed char *message=
"*****                *****        ************        *****               *****\n"
"******              ******     ******************     *****               *****\n"
" ******            ******    ****              ****    ****               **** \n"
" *******          *******   ****                ****   ****               **** \n"
" ********        ********   ****                ****   ****               **** \n"
" **** ****      **** ****   ****                       ****               **** \n"
" ****  ****    ****  ****   ****                       ****               **** \n"
" ****   ****  ****   ****   ****                       ****               **** \n"
" ****    ********    ****    ****                      ****               **** \n"
" ****     ******     ****      ***************         ****               **** \n"
" ****      ****      ****         ***************      ****               **** \n"
" ****       **       ****                      ****    ****               **** \n"
" ****                ****                       ****   ****               **** \n"
" ****                ****                       ****   ****               **** \n"
" ****                ****                       ****   ****               **** \n"
" ****                ****   ****                ****   ****               **** \n"
" ****                ****   ****                ****   ****               **** \n"
" ****                ****    ****              ****     ****             ****  \n"
"*****                *****     ******************         *****************    \n"
"*****                *****        ************               ***********       \n"
"CAPA comes with ABSOLUTELY NO WARRANTY                                         \n"
"This is free software, and you are welcome                                     \n"
"to redistribute it under certain conditions; check the COPYING file.           \n";
  fprintf(stderr,message);
  exit(0);
}
