/* broken start on an command line method for setting the DB Header
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include "capaCommon.h"

void printUsage(char* progname)
{
  printf("USAGE: %s [-opendate opendate] [-opentime opentime] \n\
           [-duedate duedate]   [-duetime duetime]  \n\
           [-ansdate ansdate]   [-anstime anstime]  \n\
           [-set setnumber] [-dir class-directory] [-h] \n", progname);
  printf("       -h              : prints this message\n");
  printf("       CAPA version %s, %s\n",CAPA_VER,COMPILE_DATE);
}

/*stolen from quizzer.funct.c*/
int checkDate(char* date)
{ 
  if (date==NULL) goto wrong;
  if (strlen(date)!=8) goto wrong;

  switch(date[0]) {
  case '0':
    if (!isdigit(date[1])) goto wrong;
    break;
  case '1':
    if (!(
	  (date[1]=='0') ||
	  (date[1]=='1') ||
	  (date[1]=='2')
	  )
	) goto wrong;
    break;
  case '2':
    if (!(
	  (date[1]=='0') ||
	  (date[1]=='1') ||
	  (date[1]=='2') ||
	  (date[1]=='3') ||
	  (date[1]=='4')
	  )
	) goto wrong;
    break;
  default:
    goto wrong;
    break;
  }
  if (date[2] != '/') goto wrong;
  switch(date[3]) {
  case '0':
  case '1':
  case '2':
    if (!isdigit(date[4])) goto wrong;
    break;
  case '3':
    if (!(
	  (date[4]=='0') ||
	  (date[4]=='1') 
	  )
	) goto wrong;
    break;
  default:
    goto wrong;
    break;
  }
  if (date[5] != '/') goto wrong;
  if (!isdigit(date[6])) goto wrong;
  if (!isdigit(date[7])) goto wrong;
  goto right;
wrong:
  return 0;
right:
  return 1;
}

/* stolen from quizzer.funct.c*/
int checkTime(char* time)
{
  if (time==NULL) goto wrong;
  if (strlen(time)!=5) goto wrong;

  switch(time[0]) {
  case '0':
    if (!isdigit(time[1])) goto wrong;
    break;
  case '1':
    if (!(isdigit(time[1])))
      goto wrong;
    break;
  case '2':
    switch(time[1])
      {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
	break;
      default:
	goto wrong;
	break;
      }
    break;
  default:
    goto wrong;
    break;
  }
  if (time[2] != ':') goto wrong;
  switch (time[3]) {
  case '0':
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
    break;
  default:
    goto wrong;
    break;
  }
  if (!isdigit(time[4])) goto wrong;
  goto right;
  
wrong:
  return 0;
right:
  return 1;
}

int main(int argc, char** argv) 
{
  char *openDate="01/01/98",*openTime="01/01/98",
    *dueDate="01/01/99",*dueTime="01/01/99",
    *ansDate="01/01/99",*ansTime="01/01/99";
  char *directory=NULL,*class=NULL,cwd[FILE_NAME_LENGTH];
  char *problemWeights;
  char *partialCredit;
  int numQuestions=0,set=1,result,i=0;  
  T_header header;
  T_student student;
  Problem_t *headProblem,*currentProblem;

  for(i=1;i<argc-1;i++) {
    if        (0==strcmp(argv[i],"-opendate")  ) { if (checkDate(argv[i+1])) openDate=argv[i+1];
    } else if (0==strcmp(argv[i],"-opentime")  ) { if (checkTime(argv[i+1])) openTime=argv[i+1];
    } else if (0==strcmp(argv[i],"-duedate")   ) { if (checkDate(argv[i+1])) dueDate=argv[i+1];
    } else if (0==strcmp(argv[i],"-duetime")   ) { if (checkTime(argv[i+1])) dueTime=argv[i+1];
    } else if (0==strcmp(argv[i],"-answerdate")) { if (checkDate(argv[i+1])) ansDate=argv[i+1];
    } else if (0==strcmp(argv[i],"-answertime")) { if (checkTime(argv[i+1])) ansTime=argv[i+1];
    } else if (0==strcmp(argv[i],"-set")       ) { set=atoi(argv[i+1]); 
    } else if (0==strcmp(argv[i],"-dir")       ) { directory=(argv[i+1]); 
    } else { printUsage(argv[0]);exit(0); }
  }

  if (directory) { chdir(directory); }

#if defined(NeXT) || defined(linux)
   class = getwd(cwd);
   if( class == NULL ) { class = cwd; }
#else
   class = getcwd(NULL,255);   
#endif

  printf("Creating set%d.db file in %s/records",set,class);

  result=capa_pick_student(0,&student);
  if (result==-1 || result==0 ) {
    printf("Unable to find a classl file.\n");
    exit(-1);
  }
  
  result = capa_parse(set,&headProblem,student.s_sn,&numQuestions);
  if (result==-1) {
    printf("Unable to parse the set.\n");
    exit(-2);
  }
  
  i=0;
  problemWeights=capa_malloc(numQuestions, sizeof(char));
  partialCredit=capa_malloc(numQuestions, sizeof(char));
  currentProblem=headProblem;
  while (currentProblem!=NULL) {
    problemWeights[i]=((char)(currentProblem->weight))+'0';
    partialCredit[i]=((char)(currentProblem->partial_cdt))+'0';
    currentProblem=currentProblem->next;
    i++;
  }
  
  sprintf(header.open_date,"%s %s",openDate,openTime);
  sprintf(header.due_date, "%s %s",dueDate, dueTime);
  sprintf(header.answer_date,"%s %s",ansDate,ansTime);
  sprintf(header.num_questions,"%d",numQuestions);
  
  result=capa_set_header(&header,set,problemWeights,partialCredit);

  return 0;
}





