# Copyright (c) 2008, 2009 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: ucommon
Summary: Portable C++ runtime for threads and sockets
Version: 3.0.2
Release: 0%{?dist}
License: LGPLv3+
URL: http://www.gnu.org/software/commoncpp
Source0: http://www.gnutelephony.org/dist/tarballs/ucommon-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: doxygen graphviz-gd 
Group: System Environment/Libraries
Summary: Runtime library for portable C++ threading and sockets

%description
GNU uCommon C++ is a lightweight library to facilitate using C++ design
patterns even for very deeply embedded applications, such as for systems using
uClibc along with POSIX threading support. For this reason, uCommon disables
language features that consume memory or introduce runtime overhead. uCommon
introduces some design patterns from Objective-C, such as reference counted
objects, memory pools, and smart pointers.  uCommon introduces some new
concepts for handling of thread locking and synchronization.

%package script
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: ucommon framework for script extensible applications

%package audio
Requires: %{name} = %{version}-%{release}
Group: System Environment/Libraries
Summary: ucommon framework for telephonic audio support

%package audio-tools
Requires: %{name} = %{version}-%{release}
Requires: %{name}-audio = %{version}-%{release}
Group: Applications/Multimedia
Summary: Telephonic audio file manipulation utilities

%package devel
Requires: %{name} = %{version}-%{release}
Requires: %{name}-script = %{version}-%{release}
Requires: %{name}-audio = %{version}-%{release}
Requires: %{name}-audio-tools = %{version}-%{release}
Requires: pkgconfig
Group: Development/Libraries
Summary: Headers for building ucommon applications

%package doc
Group: Documentation
Summary: Generated class documentation for ucommon

%description script
GNU uCommon C++ script is a highly specialized embedded scripting engine and 
virtual execution environment for creating script "extensible" applications.  
This system is a C++ class library which allows one to derive application
specific dialects of the core language as needed through subclassing.

%description audio
The GNU uCommon C++ telephonic audio library covers a range of functionality 
including tone generation and detection, streaming and transcoding of encoded 
audio frames, accessing of audio files on disk, and phrasebook management.

%description audio-tools
This is a collection of command line tools to manage telephonic audio files and
phrasebook libraries built from the ucommon telephonic audio library.  These
utilities may also be required to build packages which use sampled audio
libraries and phrasebooks.

%description devel
This package provides header and support files needed for building 
applications that use the uCommon library and frameworks.

%description doc
Generated class documentation for GNU uCommon C++ framework
from header files, html browsable.

%prep
%setup -q
%build

%configure --disable-static
%{__make} %{?_smp_mflags}
%{__rm} -rf doc/html
%{__make} doxy

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__chmod} 0755 %{buildroot}%{_bindir}/ucommon-config
%{__rm} %{buildroot}%{_libdir}/*.la

%clean
%{__rm} -rf %{buildroot}

%files 
%defattr(-,root,root,-)
%doc AUTHORS README COPYING COPYING.LESSER NEWS SUPPORT ChangeLog
%{_libdir}/libucommon.so.*

%files script
%defattr(-,root,root,-)
%{_libdir}/libuccscript.so.*

%files audio
%defattr(-,root,root,-)
%{_libdir}/libuccaudio.so.*

%files audio-tools
%defattr(-,root,root,-)
%{_bindir}/audiotool
%{_mandir}/man1/audiotool.*

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/ucommon/
%{_libdir}/pkgconfig/*.pc
%{_bindir}/ucommon-config
%{_mandir}/man1/ucommon-config.*

%files doc
%defattr(-,root,root,-)
%doc doc/html/*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%changelog
* Sun Jul 19 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.6-1
- fixed ucommon-config upstream.

* Tue May 05 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.5-4
- removed static libraries, fixed other build issues (#498736)

* Sun May 03 2009 - David Sugar <dyfet@gnutelephony.org> - 2.0.5-3
- spec file prepared for redhat/fedora (#498736)

