/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2015 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
      value = 24;	/* --> subs.  */
      break;
    case 139:	/* mov */
      value = 138;	/* --> umov.  */
      break;
    case 141:	/* mov */
      value = 140;	/* --> ins.  */
      break;
    case 143:	/* mov */
      value = 142;	/* --> ins.  */
      break;
    case 204:	/* mvn */
      value = 203;	/* --> not.  */
      break;
    case 259:	/* mov */
      value = 258;	/* --> orr.  */
      break;
    case 314:	/* sxtl */
      value = 313;	/* --> sshll.  */
      break;
    case 316:	/* sxtl2 */
      value = 315;	/* --> sshll2.  */
      break;
    case 336:	/* uxtl */
      value = 335;	/* --> ushll.  */
      break;
    case 338:	/* uxtl2 */
      value = 337;	/* --> ushll2.  */
      break;
    case 431:	/* mov */
      value = 430;	/* --> dup.  */
      break;
    case 498:	/* sxtw */
    case 497:	/* sxth */
    case 496:	/* sxtb */
    case 499:	/* asr */
    case 495:	/* sbfx */
    case 494:	/* sbfiz */
      value = 493;	/* --> sbfm.  */
      break;
    case 502:	/* bfxil */
    case 501:	/* bfi */
      value = 500;	/* --> bfm.  */
      break;
    case 507:	/* uxth */
    case 506:	/* uxtb */
    case 509:	/* lsr */
    case 508:	/* lsl */
    case 505:	/* ubfx */
    case 504:	/* ubfiz */
      value = 503;	/* --> ubfm.  */
      break;
    case 527:	/* cset */
    case 526:	/* cinc */
      value = 525;	/* --> csinc.  */
      break;
    case 530:	/* csetm */
    case 529:	/* cinv */
      value = 528;	/* --> csinv.  */
      break;
    case 532:	/* cneg */
      value = 531;	/* --> csneg.  */
      break;
    case 557:	/* lsl */
      value = 556;	/* --> lslv.  */
      break;
    case 559:	/* lsr */
      value = 558;	/* --> lsrv.  */
      break;
    case 561:	/* asr */
      value = 560;	/* --> asrv.  */
      break;
    case 563:	/* ror */
      value = 562;	/* --> rorv.  */
      break;
    case 573:	/* mul */
      value = 572;	/* --> madd.  */
      break;
    case 575:	/* mneg */
      value = 574;	/* --> msub.  */
      break;
    case 577:	/* smull */
      value = 576;	/* --> smaddl.  */
      break;
    case 579:	/* smnegl */
      value = 578;	/* --> smsubl.  */
      break;
    case 582:	/* umull */
      value = 581;	/* --> umaddl.  */
      break;
    case 584:	/* umnegl */
      value = 583;	/* --> umsubl.  */
      break;
    case 595:	/* ror */
      value = 594;	/* --> extr.  */
      break;
    case 695:	/* strb */
      value = 693;	/* --> sturb.  */
      break;
    case 696:	/* ldrb */
      value = 694;	/* --> ldurb.  */
      break;
    case 698:	/* ldrsb */
      value = 697;	/* --> ldursb.  */
      break;
    case 701:	/* str */
      value = 699;	/* --> stur.  */
      break;
    case 702:	/* ldr */
      value = 700;	/* --> ldur.  */
      break;
    case 705:	/* strh */
      value = 703;	/* --> sturh.  */
      break;
    case 706:	/* ldrh */
      value = 704;	/* --> ldurh.  */
      break;
    case 708:	/* ldrsh */
      value = 707;	/* --> ldursh.  */
      break;
    case 711:	/* str */
      value = 709;	/* --> stur.  */
      break;
    case 712:	/* ldr */
      value = 710;	/* --> ldur.  */
      break;
    case 714:	/* ldrsw */
      value = 713;	/* --> ldursw.  */
      break;
    case 716:	/* prfm */
      value = 715;	/* --> prfum.  */
      break;
    case 758:	/* bic */
      value = 757;	/* --> and.  */
      break;
    case 760:	/* mov */
      value = 759;	/* --> orr.  */
      break;
    case 763:	/* tst */
      value = 762;	/* --> ands.  */
      break;
    case 768:	/* uxtw */
    case 767:	/* mov */
      value = 766;	/* --> orr.  */
      break;
    case 770:	/* mvn */
      value = 769;	/* --> orn.  */
      break;
    case 774:	/* tst */
      value = 773;	/* --> ands.  */
      break;
    case 900:	/* staddb */
      value = 804;	/* --> ldaddb.  */
      break;
    case 901:	/* staddh */
      value = 805;	/* --> ldaddh.  */
      break;
    case 902:	/* stadd */
      value = 806;	/* --> ldadd.  */
      break;
    case 903:	/* staddlb */
      value = 808;	/* --> ldaddlb.  */
      break;
    case 904:	/* staddlh */
      value = 811;	/* --> ldaddlh.  */
      break;
    case 905:	/* staddl */
      value = 814;	/* --> ldaddl.  */
      break;
    case 906:	/* stclrb */
      value = 816;	/* --> ldclrb.  */
      break;
    case 907:	/* stclrh */
      value = 817;	/* --> ldclrh.  */
      break;
    case 908:	/* stclr */
      value = 818;	/* --> ldclr.  */
      break;
    case 909:	/* stclrlb */
      value = 820;	/* --> ldclrlb.  */
      break;
    case 910:	/* stclrlh */
      value = 823;	/* --> ldclrlh.  */
      break;
    case 911:	/* stclrl */
      value = 826;	/* --> ldclrl.  */
      break;
    case 912:	/* steorb */
      value = 828;	/* --> ldeorb.  */
      break;
    case 913:	/* steorh */
      value = 829;	/* --> ldeorh.  */
      break;
    case 914:	/* steor */
      value = 830;	/* --> ldeor.  */
      break;
    case 915:	/* steorlb */
      value = 832;	/* --> ldeorlb.  */
      break;
    case 916:	/* steorlh */
      value = 835;	/* --> ldeorlh.  */
      break;
    case 917:	/* steorl */
      value = 838;	/* --> ldeorl.  */
      break;
    case 918:	/* stsetb */
      value = 840;	/* --> ldsetb.  */
      break;
    case 919:	/* stseth */
      value = 841;	/* --> ldseth.  */
      break;
    case 920:	/* stset */
      value = 842;	/* --> ldset.  */
      break;
    case 921:	/* stsetlb */
      value = 844;	/* --> ldsetlb.  */
      break;
    case 922:	/* stsetlh */
      value = 847;	/* --> ldsetlh.  */
      break;
    case 923:	/* stsetl */
      value = 850;	/* --> ldsetl.  */
      break;
    case 924:	/* stsmaxb */
      value = 852;	/* --> ldsmaxb.  */
      break;
    case 925:	/* stsmaxh */
      value = 853;	/* --> ldsmaxh.  */
      break;
    case 926:	/* stsmax */
      value = 854;	/* --> ldsmax.  */
      break;
    case 927:	/* stsmaxlb */
      value = 856;	/* --> ldsmaxlb.  */
      break;
    case 928:	/* stsmaxlh */
      value = 859;	/* --> ldsmaxlh.  */
      break;
    case 929:	/* stsmaxl */
      value = 862;	/* --> ldsmaxl.  */
      break;
    case 930:	/* stsminb */
      value = 864;	/* --> ldsminb.  */
      break;
    case 931:	/* stsminh */
      value = 865;	/* --> ldsminh.  */
      break;
    case 932:	/* stsmin */
      value = 866;	/* --> ldsmin.  */
      break;
    case 933:	/* stsminlb */
      value = 868;	/* --> ldsminlb.  */
      break;
    case 934:	/* stsminlh */
      value = 871;	/* --> ldsminlh.  */
      break;
    case 935:	/* stsminl */
      value = 874;	/* --> ldsminl.  */
      break;
    case 936:	/* stumaxb */
      value = 876;	/* --> ldumaxb.  */
      break;
    case 937:	/* stumaxh */
      value = 877;	/* --> ldumaxh.  */
      break;
    case 938:	/* stumax */
      value = 878;	/* --> ldumax.  */
      break;
    case 939:	/* stumaxlb */
      value = 880;	/* --> ldumaxlb.  */
      break;
    case 940:	/* stumaxlh */
      value = 883;	/* --> ldumaxlh.  */
      break;
    case 941:	/* stumaxl */
      value = 886;	/* --> ldumaxl.  */
      break;
    case 942:	/* stuminb */
      value = 888;	/* --> lduminb.  */
      break;
    case 943:	/* stuminh */
      value = 889;	/* --> lduminh.  */
      break;
    case 944:	/* stumin */
      value = 890;	/* --> ldumin.  */
      break;
    case 945:	/* stuminlb */
      value = 892;	/* --> lduminlb.  */
      break;
    case 946:	/* stuminlh */
      value = 895;	/* --> lduminlh.  */
      break;
    case 947:	/* stuminl */
      value = 898;	/* --> lduminl.  */
      break;
    case 949:	/* mov */
      value = 948;	/* --> movn.  */
      break;
    case 951:	/* mov */
      value = 950;	/* --> movz.  */
      break;
    case 962:	/* sevl */
    case 961:	/* sev */
    case 960:	/* wfi */
    case 959:	/* wfe */
    case 958:	/* yield */
    case 957:	/* nop */
      value = 956;	/* --> hint.  */
      break;
    case 971:	/* tlbi */
    case 970:	/* ic */
    case 969:	/* dc */
    case 968:	/* at */
      value = 967;	/* --> sys.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ins_regno (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ins_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ins_reglane (self, info, code, inst);
    case 31:
      return aarch64_ins_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ins_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 59:
      return aarch64_ins_limm (self, info, code, inst);
    case 60:
      return aarch64_ins_aimm (self, info, code, inst);
    case 61:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ins_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ins_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ins_barrier (self, info, code, inst);
    case 87:
      return aarch64_ins_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
