/* Default `INFINITY' constant.
   Copyright (C) 2004-2015 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#ifndef _MATH_H
# error "Never use <bits/inf.h> directly; include <math.h> instead."
#endif

/* If we don't have real infinity, then we're supposed to produce a float
   value that overflows at translation time, which is required to produce
   a diagnostic.  GCC's __builtin_inff produces a quite nice diagnostic
   that tells the user that the target doesn't support infinities.  */

#if __GNUC_PREREQ(3,3)
# define INFINITY	(__builtin_inff())
#else
# define INFINITY	(1e9999f)
#endif
