/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class X500Name
implements Principal {
    public static final OID CN = new OID("2.5.4.3");
    public static final OID C = new OID("2.5.4.6");
    public static final OID L = new OID("2.5.4.7");
    public static final OID ST = new OID("2.5.4.8");
    public static final OID STREET = new OID("2.5.4.9");
    public static final OID O = new OID("2.5.4.10");
    public static final OID OU = new OID("2.5.4.11");
    public static final OID T = new OID("2.5.4.12");
    public static final OID DNQ = new OID("2.5.4.46");
    public static final OID NAME = new OID("2.5.4.41");
    public static final OID GIVENNAME = new OID("2.5.4.42");
    public static final OID INITIALS = new OID("2.5.4.43");
    public static final OID GENERATION = new OID("2.5.4.44");
    public static final OID EMAIL = new OID("1.2.840.113549.1.9.1");
    public static final OID DC = new OID("0.9.2342.19200300.100.1.25");
    public static final OID UID = new OID("0.9.2342.19200300.100.1.1");
    private List components = new LinkedList();
    private Map currentRdn = new LinkedHashMap();
    private boolean fixed;
    private String stringRep;
    private byte[] encoded;
    private int sep;

    public String getName() {
        return this.toString();
    }

    public void newRelativeDistinguishedName() {
        if (this.fixed || this.currentRdn.isEmpty()) {
            return;
        }
        this.currentRdn = new LinkedHashMap();
        this.components.add(this.currentRdn);
    }

    public int size() {
        return this.components.size();
    }

    public int countComponents() {
        int count = 0;
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            count += ((Map)it.next()).size();
        }
        return count;
    }

    public boolean containsComponent(OID oid, String value) {
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map rdn = (Map)it.next();
            String s = (String)rdn.get(oid);
            if (s == null || !X500Name.compressWS(value).equalsIgnoreCase(X500Name.compressWS(s))) continue;
            return true;
        }
        return false;
    }

    public String getComponent(OID oid) {
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map rdn = (Map)it.next();
            if (!rdn.containsKey(oid)) continue;
            return (String)rdn.get(oid);
        }
        return null;
    }

    public String getComponent(OID oid, int rdn) {
        if (rdn >= this.size()) {
            return null;
        }
        return (String)((Map)this.components.get(rdn)).get(oid);
    }

    public void putComponent(OID oid, String value) {
        this.currentRdn.put(oid, value);
    }

    public void putComponent(String name, String value) {
        if ((name = name.trim().toLowerCase()).equals("cn")) {
            this.putComponent(CN, value);
        } else if (name.equals("c")) {
            this.putComponent(C, value);
        } else if (name.equals("l")) {
            this.putComponent(L, value);
        } else if (name.equals("street")) {
            this.putComponent(STREET, value);
        } else if (name.equals("st")) {
            this.putComponent(ST, value);
        } else if (name.equals("t")) {
            this.putComponent(T, value);
        } else if (name.equals("dnq")) {
            this.putComponent(DNQ, value);
        } else if (name.equals("name")) {
            this.putComponent(NAME, value);
        } else if (name.equals("givenname")) {
            this.putComponent(GIVENNAME, value);
        } else if (name.equals("initials")) {
            this.putComponent(INITIALS, value);
        } else if (name.equals("generation")) {
            this.putComponent(GENERATION, value);
        } else if (name.equals("email")) {
            this.putComponent(EMAIL, value);
        } else if (name.equals("dc")) {
            this.putComponent(DC, value);
        } else if (name.equals("uid")) {
            this.putComponent(UID, value);
        } else {
            this.putComponent(new OID(name), value);
        }
    }

    public void setUnmodifiable() {
        if (this.fixed) {
            return;
        }
        this.fixed = true;
        ArrayList newComps = new ArrayList(this.components.size());
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map rdn = (Map)it.next();
            rdn = Collections.unmodifiableMap(rdn);
            newComps.add(rdn);
        }
        this.components = Collections.unmodifiableList(newComps);
        this.currentRdn = Collections.EMPTY_MAP;
    }

    public int hashCode() {
        int sum = 0;
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry e = it2.next();
                sum += e.getKey().hashCode();
                sum += e.getValue().hashCode();
            }
        }
        return sum;
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500Name)) {
            return false;
        }
        if (this.size() != ((X500Name)o).size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            Map m = (Map)this.components.get(i);
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry e = it2.next();
                OID oid = (OID)e.getKey();
                String v1 = (String)e.getValue();
                String v2 = ((X500Name)o).getComponent(oid, i);
                if (X500Name.compressWS(v1).equalsIgnoreCase(X500Name.compressWS(v2))) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.fixed && this.stringRep != null) {
            return this.stringRep;
        }
        StringBuffer str = new StringBuffer();
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                OID oid = (OID)entry.getKey();
                String value = (String)entry.getValue();
                if (oid.equals(CN)) {
                    str.append("CN");
                } else if (oid.equals(C)) {
                    str.append("C");
                } else if (oid.equals(L)) {
                    str.append("L");
                } else if (oid.equals(ST)) {
                    str.append("ST");
                } else if (oid.equals(STREET)) {
                    str.append("STREET");
                } else if (oid.equals(O)) {
                    str.append("O");
                } else if (oid.equals(OU)) {
                    str.append("OU");
                } else if (oid.equals(T)) {
                    str.append("T");
                } else if (oid.equals(DNQ)) {
                    str.append("DNQ");
                } else if (oid.equals(NAME)) {
                    str.append("NAME");
                } else {
                    str.append(oid.toString());
                }
                str.append('=');
                str.append(value);
                if (!it2.hasNext()) continue;
                str.append("+");
            }
            if (!it.hasNext()) continue;
            str.append(',');
        }
        this.stringRep = str.toString();
        return this.stringRep;
    }

    public byte[] getDer() {
        if (this.fixed && this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        ArrayList<DERValue> name = new ArrayList<DERValue>(this.components.size());
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            if (m.isEmpty()) continue;
            HashSet<DERValue> rdn = new HashSet<DERValue>();
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                ArrayList<DERValue> atav = new ArrayList<DERValue>(2);
                atav.add(new DERValue(6, e.getKey()));
                atav.add(new DERValue(12, e.getValue()));
                rdn.add(new DERValue(48, atav));
            }
            name.add(new DERValue(49, rdn));
        }
        DERValue val = new DERValue(48, name);
        this.encoded = val.getEncoded();
        return (byte[])this.encoded.clone();
    }

    private final void parseString(String str) throws IOException {
        String key;
        StringReader in = new StringReader(str);
        while ((key = this.readAttributeType(in)) != null) {
            String value = this.readAttributeValue(in);
            this.putComponent(key, value);
            if (this.sep != 44) continue;
            this.newRelativeDistinguishedName();
        }
        this.setUnmodifiable();
    }

    private final String readAttributeType(Reader in) throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = in.read()) != 61) {
            if (ch == -1) {
                if (buf.length() > 0) {
                    throw new EOFException();
                }
                return null;
            }
            if (ch > 127) {
                throw new IOException("Invalid char: " + (char)ch);
            }
            if (Character.isLetterOrDigit((char)ch) || ch == 45 || ch == 46) {
                buf.append((char)ch);
                continue;
            }
            throw new IOException("Invalid char: " + (char)ch);
        }
        return buf.toString();
    }

    private final String readAttributeValue(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = in.read();
        if (ch == 35) {
            while (97 <= (ch = in.read()) && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                buf.append((char)ch);
            }
            if (ch == 43 || ch == 44) {
                this.sep = ch;
                String hex = buf.toString();
                return new String(Util.toByteArray(hex));
            }
            throw new IOException("illegal character: " + (char)ch);
        }
        if (ch == 34) {
            while ((ch = in.read()) != 34) {
                if (ch == 92) {
                    ch = in.read();
                    if (ch == -1) {
                        throw new EOFException();
                    }
                    if (97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                        int i = Character.digit((char)ch, 16) << 4;
                        ch = in.read();
                        if (!(97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch))) {
                            throw new IOException("illegal hex char");
                        }
                        buf.append((char)(i |= Character.digit((char)ch, 16)));
                        continue;
                    }
                    buf.append((char)ch);
                    continue;
                }
                buf.append((char)ch);
            }
            this.sep = in.read();
            if (this.sep != 43 || this.sep != 44) {
                throw new IOException("illegal character: " + (char)ch);
            }
            return buf.toString();
        }
        while (true) {
            switch (ch) {
                case 43: 
                case 44: {
                    this.sep = ch;
                    return buf.toString();
                }
                case 92: {
                    ch = in.read();
                    if (ch == -1) {
                        throw new EOFException();
                    }
                    if (97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                        int i = Character.digit((char)ch, 16) << 4;
                        ch = in.read();
                        if (!(97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch))) {
                            throw new IOException("illegal hex char");
                        }
                        buf.append((char)(i |= Character.digit((char)ch, 16)));
                        break;
                    }
                    buf.append((char)ch);
                    break;
                }
                case 35: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    throw new IOException("illegal character: " + (char)ch);
                }
                case -1: {
                    throw new EOFException();
                }
                default: {
                    buf.append((char)ch);
                }
            }
        }
    }

    private final void parseDer(DERReader der) throws IOException {
        DERValue name = der.read();
        if (!name.isConstructed()) {
            throw new IOException("malformed Name");
        }
        this.encoded = name.getEncoded();
        int len = 0;
        while (len < name.getLength()) {
            DERValue rdn = der.read();
            if (!rdn.isConstructed()) {
                throw new IOException("badly formed RDNSequence");
            }
            int len2 = 0;
            while (len2 < rdn.getLength()) {
                DERValue atav = der.read();
                if (!atav.isConstructed()) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                DERValue val = der.read();
                if (val.getTag() != 6) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                OID oid = (OID)val.getValue();
                val = der.read();
                if (!(val.getValue() instanceof String)) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                String value = (String)val.getValue();
                this.putComponent(oid, value);
                len2 += atav.getEncodedLength();
            }
            if ((len += rdn.getEncodedLength()) >= name.getLength()) continue;
            this.newRelativeDistinguishedName();
        }
        this.setUnmodifiable();
    }

    private static final String compressWS(String str) {
        StringBuffer buf = new StringBuffer();
        char lastChar = '\u0000';
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!Character.isWhitespace(lastChar)) {
                    buf.append(' ');
                }
            } else {
                buf.append(c);
            }
            lastChar = c;
            ++i;
        }
        return buf.toString().trim();
    }

    public X500Name() {
        this.components.add(this.currentRdn);
    }

    public X500Name(String name) {
        this();
        try {
            this.parseString(name);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.toString());
        }
    }

    public X500Name(byte[] encoded) throws IOException {
        this();
        this.parseDer(new DERReader(encoded));
    }

    public X500Name(InputStream encoded) throws IOException {
        this();
        this.parseDer(new DERReader(encoded));
    }
}

