/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_sh.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_asm[] = { "asm", "ASM" };
wchar_t *keyword_asm[] = {
      //x86 assembly instructions
      L"AAA",
      L"AAD",
      L"AAM",
      L"AAS",
      L"AAC",
      L"ADD",
      L"AND",
      L"CALL",
      L"CBW",
      L"CLC",
      L"CLD",
      L"CLI",
      L"CMC",
      L"CMPSB",
      L"CMPSW",
      L"CWD",
      L"DAA",
      L"DAS",
      L"DEC",
      L"DIV",
      L"ESC",
      L"HLT",
      L"IDIV",
      L"IMUL",
      L"INC",
      L"INTO",
      L"INT",
      L"INS",
      L"IN",
      L"IRET",
      L"JCC",
      L"JCXZ",
      L"JMP",
      L"LAHF",
      L"LDS",
      L"LEA",
      L"LES",
      L"LOCK",
      L"LODSB",
      L"LODSW",
      L"LOOPNE",
      L"LOOPNZ",
      L"LOOPE",
      L"LOOPZ",
      L"LOOPW",
      L"LOOPD",
      L"LOOP",
      L"MOVSB",
      L"MOVSW",
      L"MOVSD",
      L"MOVSX",
      L"MOVZX",
      L"MOVNTDQ",
      L"MOVNTI",
      L"MOVNTPD",
      L"MOVSXD",
      L"MOV",
      L"MUL",
      L"NEG",
      L"NOP",
      L"NOT",
      L"OR",
      L"OUTSD",
      L"OUT",
      L"POPFQ",
      L"PUSHFQ",
      L"POPAD",
      L"POPA",
      L"PUSHAD",
      L"PUSHFD",
      L"PUSHA",
      L"POPFD",
      L"POPF",
      L"POP",
      L"PUSHF",
      L"PUSH",
      L"RCL",
      L"RCR",
      L"REPE",
      L"PERNE",
      L"REPNZ",
      L"REPZ",
      L"REP",
      L"RETN",
      L"RETF",
      L"RET",
      L"ROL",
      L"ROR",
      L"SAHF",
      L"SAL",
      L"SAR",
      L"SBB",
      L"SCASD",
      L"SHLD",
      L"SHRD",
      L"STOSD",
      L"SCASB",
      L"SCASW",
      L"SHL",
      L"SHR",
      L"STC",
      L"STD",
      L"STI",
      L"SCASQ",
      L"STOSQ",
      L"STOSB",
      L"STOSW",
      L"SUB",
      L"TEST",
      L"WAIT",
      L"XCHG",
      L"XLAT",
      L"XOR",
      L"BOUND",
      L"ENTER",
      L"LEAVE",
      L"OUTS",
      L"ARPL",
      L"CLTS",
      L"LAR",
      L"LGDT",
      L"LIDT",
      L"LLDT",
      L"LMSW",
      L"LOADALL",
      L"LSL",
      L"LTR",
      L"SGDT",
      L"SIDT",
      L"SLDT",
      L"SMSW",
      L"STR",
      L"VERR",
      L"VERW",
      L"BSF",
      L"BSR",
      L"BTC",
      L"BTR",
      L"BTS",
      L"BT",
      L"CDQ",
      L"CMPSD",
      L"CWDE",
      L"INSD",
      L"JECXZ",
      L"LFS",
      L"LGS",
      L"LSS",
      L"SETAE",
      L"SETA",
      L"SETBE",
      L"SETB",
      L"SETC",
      L"SETE",
      L"SETGE",
      L"SETG",
      L"SETLE",
      L"SETL",
      L"SETNAE",
      L"SETNA",
      L"SETNBE",
      L"SETNB",
      L"SETNC",
      L"SETNE",
      L"SETNGE",
      L"SETNG",
      L"SETNLE",
      L"SETNL",
      L"SETNO",
      L"SETNP",
      L"SETNS",
      L"SETNZ",
      L"SETO",
      L"SETPE",
      L"SETPO",
      L"SETP",
      L"SETS",
      L"SETZ",
      L"BSWAP",
      L"CMPXCHG",
      L"INVD",
      L"INVLPG",
      L"WBINVD",
      L"XADD",
      L"CPUID",
      L"CMPXCHG8B",
      L"RDMSR",
      L"RDTSC",
      L"WRMSR",
      L"RSM",
      L"RDPMC",
      L"SYSCALL",
      L"SYSRET",
      L"CMOVAE",
      L"CMOVA",
      L"CMOVBE",
      L"CMOVB",
      L"CMOVCE",
      L"CMOVC",
      L"CMOVGE",
      L"CMOVG",
      L"CMOVLE",
      L"CMOVL",
      L"CMOVNAE",
      L"CMOVNA",
      L"CMOVNBE",
      L"CMOVNB",
      L"CMOVNC",
      L"CMOVNE",
      L"CMOVNGE",
      L"CMOVNG",
      L"CMOVNLE",
      L"CMOVNL",
      L"CMOVNO",
      L"CMOVNP",
      L"CMOVNS",
      L"CMOVNZ",
      L"CMOVO",
      L"CMOVPE",
      L"CMOVPO",
      L"CMOVP",
      L"CMOVS",
      L"CMOVZ",
      L"SYSENTER",
      L"SYSEXIT",
      L"UD2",
      L"MASKMOVQ",
      L"MOVNTPS",
      L"MOVNTQ",
      L"PREFETCH0",
      L"PREFETCH1",
      L"PREFETCH2",
      L"PREFETCHNTA",
      L"SFENCE",
      L"CLFLUSH",
      L"LFENCE",
      L"MASKMOVDQ",
      L"MFENCE",
      L"PAUSE",
      L"LDDQU",
      L"MONITOR",
      L"MWAIT",
      L"CDQE",
      L"CQO",
      L"CMPSQ",
      L"CMPXCHG16B",
      L"CMP",
      L"IRETQ",
      L"JRCXZ",
      L"LODSQ",
      L"RDTSCP",
      L"SWAPGS",
      L"STACK",
      L"DATA",
      L"CODE",
      L"TEXT",
      L"SECTION",
      L"START",
      L"SEGMENT",
      L"GLOBAL",
      L"BSS",
      L"JZ",
      L"JNZ",
      L"JE",
      L"JNE",
      L"MODEL",
      L"DB",
      L"DW",
      L"DD",
};

struct modulestruct module_asm =
{
    .extsCount      = 2,
    .exts           = ext_asm,
    .keywordCount   = 269,
    .keywords       = keyword_asm,
    .mlCommentStart = L"/*",
    .mlCommentEnd   = L"*/",
    .slCommentStart = L"#",
    .caseSensitive  = 0,
};

