/*
     This file is part of GNUnet
     Copyright (C) 2012-2022 GNUnet e.V.

     GNUnet is free software: you can redistribute it and/or modify it
     under the terms of the GNU Affero General Public License as published
     by the Free Software Foundation, either version 3 of the License,
     or (at your option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.

     You should have received a copy of the GNU Affero General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>.

     SPDX-License-Identifier: AGPL3.0-or-later
 */
 /**
  * @file include/taler_error_codes.h
  * @brief GNUnet error codes, generated via https://gana.gnunet.org/
  *
  * Do NOT edit this file, it is generated!
  */
#ifndef GNUNET_ERROR_CODES_H
#define GNUNET_ERROR_CODES_H

#ifdef __cplusplus
extern "C" {
#if 0 /* keep Emacsens' auto-indent happy */
}
#endif
#endif

#include <limits.h>


/**
 * Taler error codes.
 */
enum GNUNET_ErrorCode
{


  /**
   * No error (success).
   * Returned with an HTTP status code of #MHD_HTTP_UNINITIALIZED (0).
   */
  GNUNET_EC_NONE = 0,


  /**
   * Unknown namestore error.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_UNKNOWN = 5000,


  /**
   * Zone iteration failed.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_ITERATION_FAILED = 5001,


  /**
   * Zone not found.
   * Returned with an HTTP status code of #MHD_HTTP_NOT_FOUND (404).
   */
  GNUNET_EC_NAMESTORE_ZONE_NOT_FOUND = 5002,


  /**
   * Record not found.
   * Returned with an HTTP status code of #MHD_HTTP_NOT_FOUND (404).
   */
  GNUNET_EC_NAMESTORE_RECORD_NOT_FOUND = 5003,


  /**
   * Zone iteration failed.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_RECORD_DELETE_FAILED = 5004,


  /**
   * Zone does not contain any records.
   * Returned with an HTTP status code of #MHD_HTTP_NOT_FOUND (404).
   */
  GNUNET_EC_NAMESTORE_ZONE_EMPTY = 5005,


  /**
   * Failed to lookup record.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_LOOKUP_ERROR = 5006,


  /**
   * No records given.
   * Returned with an HTTP status code of #MHD_HTTP_BAD_REQUEST (400).
   */
  GNUNET_EC_NAMESTORE_NO_RECORDS_GIVEN = 5007,


  /**
   * Record data invalid.
   * Returned with an HTTP status code of #MHD_HTTP_BAD_REQUEST (400).
   */
  GNUNET_EC_NAMESTORE_RECORD_DATA_INVALID = 5008,


  /**
   * No label given.
   * Returned with an HTTP status code of #MHD_HTTP_BAD_REQUEST (400).
   */
  GNUNET_EC_NAMESTORE_NO_LABEL_GIVEN = 5009,


  /**
   * No results given.
   * Returned with an HTTP status code of #MHD_HTTP_NOT_FOUND (404).
   */
  GNUNET_EC_NAMESTORE_NO_RESULTS = 5010,


  /**
   * Record already exists.
   * Returned with an HTTP status code of #MHD_HTTP_CONFLICT (409).
   */
  GNUNET_EC_NAMESTORE_RECORD_EXISTS = 5011,


  /**
   * Record size exceeds maximum limit.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_RECORD_TOO_BIG = 5012,


  /**
   * There was an error in the database backend.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_BACKEND_FAILED = 5013,


  /**
   * Failed to store the given records.
   * Returned with an HTTP status code of #MHD_HTTP_INTERNAL_SERVER_ERROR (500).
   */
  GNUNET_EC_NAMESTORE_STORE_FAILED = 5014,


  /**
   * Label invalid or malformed.
   * Returned with an HTTP status code of #MHD_HTTP_BAD_REQUEST (400).
   */
  GNUNET_EC_NAMESTORE_LABEL_INVALID = 5015,


};


/**
 * Returns a hint for a given error code.
 *
 * @param ec the error code.
 * @return the hint if it could be found, otherwise "<no hint found>"
 */
const char *
GNUNET_ErrorCode_get_hint (enum GNUNET_ErrorCode ec);


/**
 * Return HTTP status for a given error code.
 *
 * @param ec the error code.
 * @return the HTTP status code for the given @a ec, UINT_MAX if not found
 */
unsigned int
GNUNET_ErrorCode_get_http_status (enum GNUNET_ErrorCode ec);


/**
 * Return HTTP status for a given error code that is guaranteed
 * to work (no corner cases).
 *
 * @param ec the error code.
 * @return the HTTP status code for the given @a ec, 500 if
 *         the @a ec is not found or is a client-side code
 */
unsigned int
GNUNET_ErrorCode_get_http_status_safe (enum GNUNET_ErrorCode ec);


#if 0 /* keep Emacsens' auto-indent happy */
{
#endif
#ifdef __cplusplus
}
#endif

#endif
